/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.bitmap;

import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.bitmap.BitmapHeader;
import com.benryan.graphics.wmf.bitmap.GDIPalette;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class DIBReader {
    private GDIPalette palette;
    private BitmapHeader header;

    public BufferedImage setRecord(MfRecord record) throws IOException {
        return this.setRecord(record, 0, false, false);
    }

    public BufferedImage setRecord(MfRecord record, int offset, boolean reverseHeight, boolean reverseWidth) throws IOException {
        offset += 6;
        if (reverseWidth) {
            int negWidth = -1 * record.getInt(offset + 4);
            record.setInt(offset + 4, negWidth);
        }
        if (reverseHeight) {
            int negHeight = -1 * record.getInt(offset + 8);
            record.setInt(offset + 8, negHeight);
        }
        byte[] fileHeader = new byte[]{66, 77, 0, 0, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0};
        byte[] dibData = record.getRawData();
        int fileSize = dibData.length - offset + fileHeader.length;
        fileHeader[2] = (byte)(fileSize & 0xFF);
        fileHeader[3] = (byte)((fileSize & 0xFF00) >> 8);
        fileHeader[4] = (byte)((fileSize & 0xFF0000) >> 16);
        fileHeader[5] = (byte)((fileSize & 0xFF000000) >> 32);
        byte[] imgBuf = new byte[fileSize];
        System.arraycopy(fileHeader, 0, imgBuf, 0, fileHeader.length);
        System.arraycopy(dibData, offset, imgBuf, fileHeader.length, dibData.length - offset);
        return ImageIO.read(new ByteArrayInputStream(imgBuf));
    }
}

