/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf;

import com.benryan.graphics.wmf.MfLogBrush;
import com.benryan.graphics.wmf.MfLogFont;
import com.benryan.graphics.wmf.MfLogPalette;
import com.benryan.graphics.wmf.MfLogPen;
import com.benryan.graphics.wmf.MfLogRegion;
import com.benryan.graphics.wmf.WmfFile;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class MfDcState
implements Cloneable {
    private int viewportOrgX = 0;
    private int viewportOrgY = 0;
    private int viewportExtX = 1;
    private int viewportExtY = 1;
    private int windowExtX = 1;
    private int windowExtY = 1;
    private MfScale viewportScale;
    private MfScale windowScale;
    private int curPosX = 0;
    private int curPosY = 0;
    private Color fgColor;
    private Color bkColor;
    private Color textColor;
    private int textAlign = 0;
    private int textCharExtra;
    private int breakCount;
    private int extraSpaceLength;
    private int bkmode;
    private MfLogBrush logBrush;
    private MfLogPen logPen;
    private MfLogFont logFont;
    private MfLogRegion logRegion;
    private MfLogPalette logPalette;
    private int polyFillMode;
    private int rop;
    private int mapMode;
    private int mapperFlag;
    private int stretchBltMode;
    private Rectangle clipRegion;
    private WmfFile parent;

    public MfDcState(WmfFile parent) {
        this.fgColor = Color.black;
        this.bkColor = Color.white;
        this.textColor = Color.black;
        this.logBrush = new MfLogBrush();
        this.logPen = new MfLogPen();
        this.parent = parent;
    }

    public MfDcState(MfDcState copy) {
        this.parent = copy.parent;
        this.windowExtX = copy.windowExtX;
        this.windowExtY = copy.windowExtY;
        this.viewportOrgX = copy.viewportOrgX;
        this.viewportOrgY = copy.viewportOrgY;
        this.viewportExtX = copy.viewportExtX;
        this.viewportExtY = copy.viewportExtY;
        this.curPosX = copy.curPosX;
        this.curPosY = copy.curPosY;
        this.fgColor = copy.fgColor;
        this.bkColor = copy.bkColor;
        this.textAlign = copy.textAlign;
        this.textCharExtra = copy.textCharExtra;
        this.textColor = copy.textColor;
        this.logBrush = copy.logBrush;
        this.logPen = copy.logPen;
        this.logFont = copy.logFont;
        this.mapMode = copy.mapMode;
        this.mapperFlag = copy.mapperFlag;
        this.stretchBltMode = copy.stretchBltMode;
        this.viewportScale = copy.viewportScale;
        this.windowScale = copy.windowScale;
        this.polyFillMode = copy.polyFillMode;
        this.rop = copy.rop;
        this.bkmode = copy.bkmode;
        this.breakCount = copy.breakCount;
        this.extraSpaceLength = copy.extraSpaceLength;
        if (copy.clipRegion != null) {
            this.clipRegion = new Rectangle(copy.clipRegion);
        }
    }

    public void restoredState() {
        Graphics2D graphic = this.parent.getGraphics2D();
        if (this.logBrush != null) {
            this.updateBrushBackground();
            graphic.setPaint(this.logBrush.getPaint());
        }
        if (this.logPen != null) {
            graphic.setStroke(this.logPen.getStroke());
        }
        if (this.logFont != null) {
            graphic.setFont(this.logFont.createFont());
        }
    }

    public Rectangle getClipRegion() {
        if (this.clipRegion == null) {
            return new Rectangle(this.viewportOrgX, this.viewportOrgY, this.viewportExtX, this.viewportExtY);
        }
        return this.clipRegion;
    }

    public void setClipRegion(Rectangle clipRegion) {
        this.clipRegion = clipRegion;
    }

    public int getBkMode() {
        return this.bkmode;
    }

    public void setBkMode(int bkmode) {
        if (this.bkmode != bkmode) {
            this.bkmode = bkmode;
            this.updateBrushBackground();
        }
    }

    private void updateBrushBackground() {
        if (this.bkmode == 1) {
            this.logBrush.setBackgroundColor(new Color(0xFFFFFF, true));
        } else {
            this.logBrush.setBackgroundColor(this.getBkColor());
        }
    }

    public int getBreakCount() {
        return this.breakCount;
    }

    public int getExtraSpaceLength() {
        return this.extraSpaceLength;
    }

    public void setTextJustification(int breakCount, int extraSpaceLength) {
        this.breakCount = breakCount;
        this.extraSpaceLength = extraSpaceLength;
    }

    public int getStretchBltMode() {
        return this.stretchBltMode;
    }

    public void setStretchBltMode(int stretchBltMode) {
        this.stretchBltMode = stretchBltMode;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public int getTextCharExtra() {
        return this.textCharExtra;
    }

    public void setTextCharExtra(int textCharExtra) {
        this.textCharExtra = textCharExtra;
    }

    public int getMapMode() {
        return this.mapMode;
    }

    public void setMapMode(int mapMode) {
        this.mapMode = mapMode;
    }

    public int getMapperFlag() {
        return this.mapperFlag;
    }

    public void setMapperFlag(int mapperFlag) {
        this.mapperFlag = mapperFlag;
    }

    public int getROP() {
        return this.rop;
    }

    public void setROP(int rop) {
        this.rop = rop;
    }

    public int getPolyFillMode() {
        return this.polyFillMode;
    }

    public void setPolyFillMode(int mode) {
        this.polyFillMode = mode;
    }

    public void setWindowOrg(int windowOrgX, int windowOrgY) {
        this.viewportOrgY = -windowOrgY;
        this.viewportOrgX = -windowOrgX;
    }

    public int getWindowOrgX() {
        return this.viewportOrgX;
    }

    public int getWindowOrgY() {
        return this.viewportOrgY;
    }

    public void setWindowExt(int windowExtX, int windowExtY) {
        this.windowExtY = windowExtY;
        this.windowExtX = windowExtX;
    }

    public int getWindowExtX() {
        return this.windowExtX;
    }

    public int getWindowExtY() {
        return this.windowExtY;
    }

    public void setViewportOrg(int viewportOrgX, int viewportOrgY) {
        this.viewportOrgX = viewportOrgX;
        this.viewportOrgY = viewportOrgY;
    }

    public int getViewportOrgX() {
        return this.viewportOrgX;
    }

    public int getViewportOrgY() {
        return this.viewportOrgY;
    }

    public void setViewportExt(int viewportExtX, int viewportExtY) {
        this.viewportExtY = viewportExtY;
        this.viewportExtX = viewportExtX;
    }

    public int getViewportExtX() {
        return this.viewportExtX;
    }

    public int getViewportExtY() {
        return this.viewportExtY;
    }

    public void setCurPos(int _curPosX, int _curPosY) {
        this.curPosY = _curPosY;
        this.curPosX = _curPosX;
    }

    public int getCurPosX() {
        return this.curPosX;
    }

    public int getCurPosY() {
        return this.curPosY;
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(int textAlign) {
        this.textAlign = textAlign;
    }

    public void setFgColor(Color fgColor) {
        if (fgColor == null) {
            throw new NullPointerException();
        }
        this.fgColor = fgColor;
        this.logBrush.setColor(fgColor);
        this.logPen.setColor(fgColor);
    }

    public void setBkColor(Color bkColor) {
        if (bkColor == null) {
            throw new NullPointerException();
        }
        this.bkColor = bkColor;
        this.logBrush.setBackgroundColor(bkColor);
    }

    public Color getFgColor() {
        return this.fgColor;
    }

    public Color getBkColor() {
        return this.bkColor;
    }

    public MfLogFont getLogFont() {
        return this.logFont;
    }

    public MfLogBrush getLogBrush() {
        return this.logBrush;
    }

    public MfLogPen getLogPen() {
        return this.logPen;
    }

    public void setLogFont(MfLogFont logFont) {
        if (logFont == null) {
            throw new NullPointerException();
        }
        this.logFont = logFont;
    }

    public void setLogBrush(MfLogBrush logBrush) {
        if (logBrush == null) {
            throw new NullPointerException();
        }
        this.logBrush = logBrush;
        this.updateBrushBackground();
        this.parent.getGraphics2D().setPaint(logBrush.getPaint());
    }

    public void setLogPen(MfLogPen logPen) {
        if (logPen == null) {
            throw new NullPointerException();
        }
        this.logPen = logPen;
        this.parent.getGraphics2D().setStroke(logPen.getStroke());
    }

    public void setLogPalette(MfLogPalette logPalette) {
        if (logPalette == null) {
            throw new NullPointerException();
        }
        this.logPalette = logPalette;
    }

    public void setLogRegion(MfLogRegion logRegion) {
        if (logRegion == null) {
            throw new NullPointerException();
        }
        this.logRegion = logRegion;
    }

    public int getPhysicalX(int logPointX) {
        return logPointX + this.viewportOrgX;
    }

    public int getPhysicalY(int logPointY) {
        return logPointY + this.viewportOrgY;
    }

    public void prepareDraw() {
        this.parent.getGraphics2D().setPaint(this.logPen.getColor());
    }

    public void postDraw() {
        this.parent.getGraphics2D().setPaint(this.logBrush.getPaint());
    }

    public void prepareDrawText() {
        this.parent.getGraphics2D().setPaint(this.textColor);
        this.parent.getGraphics2D().setFont(this.logFont.createFont());
    }

    public void postDrawText() {
        this.parent.getGraphics2D().setPaint(this.logBrush.getPaint());
    }

    public void preparePaint() {
        this.parent.getGraphics2D().setPaint(this.logBrush.getPaint());
    }

    public void postPaint() {
    }

    public int getVerticalTextAlignment() {
        return this.textAlign & 6;
    }

    public int getHorizontalTextAlignment() {
        return this.textAlign & 0x18;
    }

    public MfLogRegion getLogRegion() {
        return this.logRegion;
    }

    public MfLogPalette getLogPalette() {
        return this.logPalette;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public class MfScale {
        private int yNum;
        private int xNum;
        private int yDenom;
        private int xDenom;

        public MfScale(int xNum, int xDenom, int yNum, int yDenom) {
            if (xNum == 0 || yNum == 0 || xDenom == 0 || yDenom == 0) {
                throw new IllegalArgumentException("Illegal Scaling");
            }
            this.xNum = xNum;
            this.yNum = yNum;
            this.xDenom = xDenom;
            this.yDenom = yDenom;
        }

        public int scaleX(int coord) {
            return coord * this.xNum / this.xDenom;
        }

        public int scaleY(int coord) {
            return coord * this.yNum / this.yDenom;
        }
    }
}

