/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.entity.config.JdbcDatasourceInfo;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionTracker;
import org.ofbiz.core.util.Debug;
import tyrex.resource.jdbc.xa.EnabledDataSource;

public class TyrexConnectionFactory {
    protected static Map<String, EnabledDataSource> dsCache = CopyOnWriteMap.newHashMap();
    protected static Map<String, ConnectionTracker> trackerCache = CopyOnWriteMap.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String helperName, JdbcDatasourceInfo jdbcDatasource) throws SQLException, GenericEntityException {
        EnabledDataSource ds = dsCache.get(helperName);
        if (ds != null) {
            return TyrexConnectionFactory.trackConnection(helperName, ds);
        }
        Class<TyrexConnectionFactory> clazz = TyrexConnectionFactory.class;
        synchronized (TyrexConnectionFactory.class) {
            ds = dsCache.get(helperName);
            if (ds != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return TyrexConnectionFactory.trackConnection(helperName, ds);
            }
            ds = new EnabledDataSource();
            ds.setDriverClassName(jdbcDatasource.getDriverClassName());
            ds.setDriverName(jdbcDatasource.getUri());
            ds.setUser(jdbcDatasource.getUsername());
            ds.setPassword(jdbcDatasource.getPassword());
            ds.setDescription(helperName);
            String transIso = jdbcDatasource.getIsolationLevel();
            if (transIso != null && transIso.length() > 0) {
                ds.setIsolationLevel(transIso);
            }
            ds.setLogWriter(Debug.getPrintWriter());
            dsCache.put(helperName, ds);
            trackerCache.put(helperName, new ConnectionTracker());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return TyrexConnectionFactory.trackConnection(helperName, ds);
        }
    }

    private static Connection trackConnection(String helperName, final EnabledDataSource ds) {
        ConnectionTracker connectionTracker = trackerCache.get(helperName);
        return connectionTracker.trackConnection(helperName, new Callable<Connection>(){

            @Override
            public Connection call() throws Exception {
                return TransactionUtil.enlistConnection(ds.getXAConnection());
            }
        });
    }
}

