/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc.dbtype;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;
import org.ofbiz.core.util.Debug;

public abstract class AbstractDatabaseType
implements DatabaseType {
    private static final String SEPARATOR = ",";
    protected static final String CHANGE_COLUMN_TYPE_CLAUSE_STRUCTURE_STANDARD_ALTER_COLUMN = "ALTER TABLE {0} ALTER COLUMN {1} {2}";
    protected static final String CHANGE_COLUMN_TYPE_CLAUSE_STRUCTURE_STANDARD_MODIFY = "ALTER TABLE {0} MODIFY {1} {2}";
    protected static final String DROP_INDEX_SCHEMA_DOT_INDEX = "DROP INDEX {schemaName_with_dot}{indexName}";
    protected static final String DROP_INDEX_SCHEMA_DOT_TABLE_DOT_INDEX = "DROP INDEX {schemaName_with_dot}{tableName}.{indexName}";
    protected static final String ALTER_TABLE_DROP_INDEX = "ALTER TABLE {schemaName_with_dot}{tableName} DROP INDEX {indexName}";
    protected static final String STANDARD_SELECT_FOR_UPDATE_SYNTAX = "SELECT {0} FROM {1} WHERE {2} FOR UPDATE";
    private final String name;
    private Set<String> sqlKeywords;
    private final String fieldTypeName;
    private final String[] productNamePrefix;
    private final int constraintNameClipLength;
    private static final int STANDARD_CONSTRAINT_NAME_CLIP_LENGTH = 30;

    protected AbstractDatabaseType(String name, String fieldTypeName, String[] productNamePrefix, int constraintNameClipLength) {
        this.name = name;
        this.fieldTypeName = fieldTypeName;
        this.productNamePrefix = productNamePrefix;
        this.constraintNameClipLength = constraintNameClipLength;
        this.registerWithFactory();
    }

    protected AbstractDatabaseType(String name, String fieldTypeName, String[] productNamePrefix) {
        this(name, fieldTypeName, productNamePrefix, 30);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFieldTypeName() {
        return this.fieldTypeName;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getSchemaName(Connection con) {
        return null;
    }

    @Override
    public int getConstraintNameClipLength() {
        return this.constraintNameClipLength;
    }

    @Override
    public abstract boolean matchesConnection(Connection var1) throws SQLException;

    protected void registerWithFactory() {
        DatabaseTypeFactory.registerDatabaseType(this);
    }

    protected static boolean versionGreaterThanOrEqual(int major1, int minor1, int major2, int minor2) {
        return major1 > major2 || major1 == major2 && minor1 >= minor2;
    }

    protected static boolean productNamesMatch(String productNamePrefix, String testName) {
        return testName != null && testName.length() >= productNamePrefix.length() && testName.substring(0, productNamePrefix.length()).equalsIgnoreCase(productNamePrefix);
    }

    protected static boolean isProductNameInPrefixList(String[] productNamePrefixes, String productName) {
        if (productName != null) {
            for (String productNamePrefix : productNamePrefixes) {
                if (!AbstractDatabaseType.productNamesMatch(productNamePrefix, productName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean productNameMatches(Connection con) throws SQLException {
        String productName = con.getMetaData().getDatabaseProductName();
        return productName != null && AbstractDatabaseType.isProductNameInPrefixList(this.productNamePrefix, productName.trim());
    }

    protected boolean versionGreaterThanOrEqual(Connection con, int majorVersion, int minorVersion) throws SQLException {
        try {
            DatabaseMetaData metaData = con.getMetaData();
            return AbstractDatabaseType.versionGreaterThanOrEqual(metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion(), majorVersion, minorVersion);
        }
        catch (AbstractMethodError ame) {
            return false;
        }
    }

    protected boolean versionLessThanOrEqual(Connection con, int majorVersion, int minorVersion) throws SQLException {
        try {
            DatabaseMetaData metaData = con.getMetaData();
            return AbstractDatabaseType.versionGreaterThanOrEqual(majorVersion, minorVersion, metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion());
        }
        catch (AbstractMethodError ame) {
            return false;
        }
    }

    protected String getChangeColumnTypeStructure() {
        return null;
    }

    @Override
    public final String getChangeColumnTypeSQL(String tableName, String columnName, String targetSqlType) {
        String clauseStructure = this.getChangeColumnTypeStructure();
        return clauseStructure == null ? null : MessageFormat.format(clauseStructure, tableName, columnName, targetSqlType);
    }

    public String getDropIndexStructure() {
        return DROP_INDEX_SCHEMA_DOT_TABLE_DOT_INDEX;
    }

    @Override
    public String getDropIndexSQL(String schemaName, String tableName, String indexName) {
        return this.getDropIndexStructure().replaceAll("\\{schemaName_with_dot}", AbstractDatabaseType.appendDotIfNotEmpty(schemaName)).replaceAll("\\{tableName}", tableName).replaceAll("\\{indexName}", indexName);
    }

    private static String appendDotIfNotEmpty(String schemaName) {
        return schemaName != null && !schemaName.isEmpty() ? schemaName + '.' : "";
    }

    @Override
    public DatabaseType initialize(Connection con) {
        try {
            this.sqlKeywords = Optional.ofNullable(con.getMetaData().getSQLKeywords()).filter(keywords -> !Strings.isNullOrEmpty((String)keywords)).map(keywords -> keywords.split(SEPARATOR)).map(Stream::of).map(stream -> stream.map(String::trim).map(String::toUpperCase).collect(Collectors.toSet())).orElse(Collections.emptySet());
            Debug.log((String)String.format("Database initialized, reserved keywords fetched %s", this.sqlKeywords));
            Debug.log((String)String.format("Escaping enabled: %s", this.enableEscaping()));
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
        }
        return this;
    }

    @Override
    public Set<String> getReservedKeywords() {
        return this.sqlKeywords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDatabaseType that = (AbstractDatabaseType)o;
        return this.name.equals(that.name) && this.fieldTypeName.equals(that.fieldTypeName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldTypeName);
    }
}

