/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.config;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.ofbiz.core.config.FileLoader;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.ResourceLoader;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ResourceHandler {
    protected String xmlFilename;
    protected String loaderName;
    protected String location;

    public ResourceHandler(String xmlFilename, Element element) {
        this.xmlFilename = xmlFilename;
        this.loaderName = element.getAttribute("loader");
        this.location = element.getAttribute("location");
    }

    public ResourceHandler(String xmlFilename, String loaderName, String location) {
        this.xmlFilename = xmlFilename;
        this.loaderName = loaderName;
        this.location = location;
    }

    public String getLoaderName() {
        return this.loaderName;
    }

    public String getLocation() {
        return this.location;
    }

    public Document getDocument() throws GenericConfigException {
        try {
            return UtilXml.readXmlDocument(this.getStream());
        }
        catch (SAXException e) {
            throw new GenericConfigException("Error reading " + this.toString(), e);
        }
        catch (ParserConfigurationException e) {
            throw new GenericConfigException("Error reading " + this.toString(), e);
        }
        catch (IOException e) {
            throw new GenericConfigException("Error reading " + this.toString(), e);
        }
    }

    public InputStream getStream() throws GenericConfigException {
        return ResourceLoader.loadResource(this.xmlFilename, this.location, this.loaderName);
    }

    public boolean isFileResource() throws GenericConfigException {
        ResourceLoader loader = ResourceLoader.getLoader(this.xmlFilename, this.loaderName);
        return loader instanceof FileLoader;
    }

    public String getFullLocation() throws GenericConfigException {
        ResourceLoader loader = ResourceLoader.getLoader(this.xmlFilename, this.loaderName);
        return loader.fullLocation(this.location);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceHandler) {
            ResourceHandler other = (ResourceHandler)obj;
            if (this.loaderName.equals(other.loaderName) && this.xmlFilename.equals(other.xmlFilename) && this.location.equals(other.location)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.xmlFilename.hashCode() + (this.loaderName.hashCode() + this.location.hashCode() >> 1) >> 1;
    }

    public String toString() {
        return "ResourceHandler from XML file [" + this.xmlFilename + "] with loaderName [" + this.loaderName + "] and location [" + this.location + "]";
    }
}

