/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.accesstoken;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JWTClaimSetBuilder {
    private static final String ISSUER_CLAIM = "iss";
    private static final String SUBJECT_CLAIM = "sub";
    private static final String AUDIENCE_CLAIM = "aud";
    private static final String EXPIRATION_TIME_CLAIM = "exp";
    private static final String NOT_BEFORE_CLAIM = "nbf";
    private static final String ISSUED_AT_CLAIM = "iat";
    private static final String JWT_ID_CLAIM = "jti";
    private final Map<String, Object> claims = new LinkedHashMap<String, Object>();

    public JWTClaimSetBuilder() {
    }

    public JWTClaimSetBuilder(JWTClaimsSet jwtClaimsSet) {
        this.claims.putAll(jwtClaimsSet.getClaims());
    }

    public JWTClaimSetBuilder issuer(String iss) {
        this.claims.put(ISSUER_CLAIM, iss);
        return this;
    }

    public JWTClaimSetBuilder subject(String sub) {
        this.claims.put(SUBJECT_CLAIM, sub);
        return this;
    }

    public JWTClaimSetBuilder audience(List<String> aud) {
        this.claims.put(AUDIENCE_CLAIM, aud);
        return this;
    }

    public JWTClaimSetBuilder audience(String aud) {
        if (aud == null) {
            this.claims.put(AUDIENCE_CLAIM, null);
        } else {
            this.claims.put(AUDIENCE_CLAIM, Collections.singletonList(aud));
        }
        return this;
    }

    public JWTClaimSetBuilder expirationTime(Date exp) {
        this.claims.put(EXPIRATION_TIME_CLAIM, exp);
        return this;
    }

    public JWTClaimSetBuilder notBeforeTime(Date nbf) {
        this.claims.put(NOT_BEFORE_CLAIM, nbf);
        return this;
    }

    public JWTClaimSetBuilder issueTime(Date iat) {
        this.claims.put(ISSUED_AT_CLAIM, iat);
        return this;
    }

    public JWTClaimSetBuilder jwtID(String jti) {
        this.claims.put(JWT_ID_CLAIM, jti);
        return this;
    }

    public JWTClaimSetBuilder claim(String name, Object value) {
        this.claims.put(name, value);
        return this;
    }

    public JWTClaimsSet build() {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        this.claims.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)builder).claim(arg_0, arg_1));
        return builder.build();
    }
}

