/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.accesstoken;

import com.atlassian.asap.core.exception.InvalidHeaderException;
import com.atlassian.oauth2.accesstoken.ConnectSessionAuthToken;
import com.nimbusds.jose.JOSEException;
import java.text.ParseException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ValidationException;

public class InvalidSessionAuthTokenException
extends ValidationException {
    public InvalidSessionAuthTokenException(String message) {
        super(message);
    }

    public InvalidSessionAuthTokenException(Set<ConnectSessionAuthToken.ConstraintViolation<ConnectSessionAuthToken>> violations) {
        this(InvalidSessionAuthTokenException.formatConstraintMessage(violations));
    }

    public InvalidSessionAuthTokenException(ParseException exception) {
        super("Failed to parse Connect Session Auth Token", (Throwable)exception);
    }

    public InvalidSessionAuthTokenException(InvalidHeaderException exception) {
        super("Connect Session Auth Token has invalid header", (Throwable)exception);
    }

    public InvalidSessionAuthTokenException(JOSEException exception) {
        super("Connect Session Auth Token has invalid jwt", (Throwable)exception);
    }

    private static String formatConstraintMessage(Set<ConnectSessionAuthToken.ConstraintViolation<ConnectSessionAuthToken>> violations) {
        StringBuilder sb = new StringBuilder();
        sb.append("Connect Session Auth Token is invalid. It has the following problems\n");
        String violationSummary = violations.stream().map(InvalidSessionAuthTokenException::formatViolation).collect(Collectors.joining("\n"));
        sb.append(violationSummary);
        return sb.toString();
    }

    private static String formatViolation(ConnectSessionAuthToken.ConstraintViolation<ConnectSessionAuthToken> violation) {
        return String.format("%s %s", violation.getPropertyPath(), violation.getMessage());
    }
}

