/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.accesstoken;

import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.core.exception.InvalidHeaderException;
import com.atlassian.asap.core.keys.KeyProvider;
import com.atlassian.asap.core.validator.ValidatedKeyId;
import com.atlassian.oauth2.accesstoken.ConnectSessionAuthToken;
import com.atlassian.oauth2.accesstoken.ConnectSessionAuthTokenValidator;
import com.atlassian.oauth2.accesstoken.InvalidSessionAuthTokenException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.nimbusds.jose.JOSEException;
import java.net.URL;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectSessionAuthTokenValidatorImpl
implements ConnectSessionAuthTokenValidator {
    private static final Logger log = LoggerFactory.getLogger(ConnectSessionAuthTokenValidatorImpl.class);
    private final KeyProvider<RSAPublicKey> publicKeyProvider;
    private final Set<String> authorizationServerIds;
    private final Set<URL> supportedResourceServerUrls;

    public ConnectSessionAuthTokenValidatorImpl(@Nonnull KeyProvider<RSAPublicKey> publicKeyProvider, @Nonnull String authorizationServerId, @Nonnull Set<URL> supportedResourceServerUrls) {
        this(publicKeyProvider, (Set<String>)ImmutableSet.of((Object)authorizationServerId), supportedResourceServerUrls);
    }

    public ConnectSessionAuthTokenValidatorImpl(@Nonnull KeyProvider<RSAPublicKey> publicKeyProvider, @Nonnull Set<String> authorizationServerIds, @Nonnull Set<URL> supportedResourceServerUrls) {
        this.publicKeyProvider = (KeyProvider)Preconditions.checkNotNull(publicKeyProvider);
        this.authorizationServerIds = (Set)Preconditions.checkNotNull(authorizationServerIds);
        this.supportedResourceServerUrls = (Set)Preconditions.checkNotNull(supportedResourceServerUrls);
    }

    @Override
    public Optional<ConnectSessionAuthToken> parseAndValidate(@Nonnull String authTokenJwt) throws InvalidSessionAuthTokenException, CannotRetrieveKeyException {
        Optional<ConnectSessionAuthToken> authToken;
        try {
            authToken = ConnectSessionAuthToken.parse(authTokenJwt);
        }
        catch (ParseException e) {
            throw new InvalidSessionAuthTokenException(e);
        }
        Optional<RSAPublicKey> maybePublicKey = this.getRsaPublicKey(authToken);
        maybePublicKey.ifPresent(publicKey -> authToken.ifPresent(token -> this.validateToken((ConnectSessionAuthToken)token, (RSAPublicKey)publicKey)));
        return authToken;
    }

    private Optional<RSAPublicKey> getRsaPublicKey(Optional<ConnectSessionAuthToken> authToken) throws CannotRetrieveKeyException {
        try {
            return authToken.map(token -> {
                try {
                    return (RSAPublicKey)this.publicKeyProvider.getKey(ValidatedKeyId.validate((String)token.keyId()));
                }
                catch (CannotRetrieveKeyException e) {
                    throw new CannotRetrieveExceptionWrapper(e);
                }
                catch (InvalidHeaderException e) {
                    throw new InvalidSessionAuthTokenException(e);
                }
            });
        }
        catch (CannotRetrieveExceptionWrapper e) {
            throw e.wrapped;
        }
    }

    private void validateToken(ConnectSessionAuthToken authToken, RSAPublicKey publicKey) throws InvalidSessionAuthTokenException {
        try {
            boolean verified = authToken.verify(publicKey);
            if (!verified) {
                throw new ValidationException("Session auth token failed key validation");
            }
            Set<ConnectSessionAuthToken.ConstraintViolation<ConnectSessionAuthToken>> violations = authToken.validate();
            if (!violations.isEmpty()) {
                throw new InvalidSessionAuthTokenException(violations);
            }
            authToken.getSessionClaimSet().ifPresent(sessionClaimSet -> {
                String tokenIssuer = sessionClaimSet.getAuthorizationServerId();
                if (tokenIssuer == null || !this.authorizationServerIds.contains(tokenIssuer)) {
                    log.info("received token from issuer {} when expecting one of {}", (Object)tokenIssuer, this.authorizationServerIds);
                    throw new ValidationException(String.format("Session auth token was not issued by the expected authorization server. Token was issued by: %s", tokenIssuer));
                }
                HashSet resourceServerUrls = Sets.newHashSet(sessionClaimSet.getResourceServerUrls());
                Sets.SetView intersection = Sets.intersection(this.supportedResourceServerUrls, (Set)resourceServerUrls);
                if (!resourceServerUrls.isEmpty() && intersection.isEmpty()) {
                    throw new ValidationException(String.format("Session auth token does not include expected resource servers in audience server. Token was issued for: %s", resourceServerUrls));
                }
            });
        }
        catch (JOSEException e) {
            throw new InvalidSessionAuthTokenException(e);
        }
        catch (ParseException e) {
            throw new InvalidSessionAuthTokenException(e);
        }
    }

    private final class CannotRetrieveExceptionWrapper
    extends RuntimeException {
        private final CannotRetrieveKeyException wrapped;

        private CannotRetrieveExceptionWrapper(CannotRetrieveKeyException cause) {
            this.wrapped = cause;
        }
    }
}

