/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.shared.sal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public final class PropertiesHelper {
    private static final Pattern PROPERTIES_COMMENT_PATTERN = Pattern.compile("^#.*$", 8);

    public static Properties asProperties(Map<String, String> properties) {
        Properties props = new Properties();
        props.putAll(properties);
        return props;
    }

    public static String toString(Properties props) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            props.store(baos, null);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"ByteArrayOutputStream should never throw an IOException");
        }
        try {
            return PROPERTIES_COMMENT_PATTERN.matcher(baos.toString("ISO-8859-1")).replaceAll("");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("It appears your JVM doesn't support ISO-8859-1 which is a required charset");
        }
    }

    public static Properties fromString(String str) {
        Properties props = new Properties();
        try {
            props.load(new ByteArrayInputStream(str.getBytes("ISO-8859-1")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("It appears your JVM doesn't support ISO-8859-1 which is a required charset");
        }
        catch (IOException e) {
            throw new AssertionError((Object)"ByteArrayInputStream can't throw IOException");
        }
        return props;
    }
}

