/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.shared.sal;

import com.google.common.base.Function;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class Functions {
    private Functions() {
    }

    public static Function<String, String> toEncodedKeys() {
        return KeyEncoder.INSTANCE;
    }

    public static final Function<String, String> toDecodedKeys() {
        return KeyDecoder.INSTANCE;
    }

    private static enum KeyDecoder implements Function<String, String>
    {
        INSTANCE;


        public String apply(String encodedKey) {
            try {
                return URLDecoder.decode(encodedKey, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Your JVM is broken", e);
            }
        }
    }

    private static enum KeyEncoder implements Function<String, String>
    {
        INSTANCE;


        public String apply(String key) {
            try {
                return URLEncoder.encode(key, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Your JVM is broken", e);
            }
        }
    }
}

