MW.Confluence = MW.Confluence || {};
MW.Confluence.Mobile = {};

MW.Confluence.Mobile.HeaderView = Backbone.View.extend({

    events: {
        "click .mw-header .flyout-button" : "toggleFlyout"
    },

    initialize: function(options){
        this.title = options.title;
        this.backText = options.backText;
    },

    toggleFlyout: function(event){
        event.stopPropagation();
        setTimeout(function() {
            ConfluenceMobile.flyout.toggle();
        }, 0);
    },

    render: function(){
        // If we are rendering this custom header, hide the original header
        $("#inner-container > .header").hide();

        var data = {};
        if (this.title) {
            _.extend(data, {title: this.title});
        }

        if (this.backText) {
            _.extend(data, {backText: this.backText});
        }

        // This is a header, so prepend to the provided container
        this.$el.prepend(MyWork.Templates.Mobile.Confluence.customHeader(data));

        return this;
    }
});