/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.client.listener;

import com.atlassian.mywork.client.listener.ServiceListener;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.google.common.base.Function;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.DisposableBean;

public class PluginModuleServiceListener
implements ServiceListener,
DisposableBean {
    private final PluginEventManager pluginEventManager;
    private final PluginAccessor pluginAccessor;
    private final Set<Function<Plugin, Void>> listeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public PluginModuleServiceListener(PluginEventManager pluginEventManager, PluginAccessor pluginAccessor) {
        this.pluginEventManager = pluginEventManager;
        this.pluginAccessor = pluginAccessor;
        pluginEventManager.register((Object)this);
    }

    public synchronized <M> Closeable addListener(final Class<M> type, final Function<M, Void> callback) {
        Function<Plugin, Void> wrappedCallback = new Function<Plugin, Void>(){

            public Void apply(Plugin plugin) {
                for (ModuleDescriptor descriptor : plugin.getModuleDescriptorsByModuleClass(type)) {
                    callback.apply(descriptor.getModule());
                }
                return null;
            }
        };
        this.listeners.add(wrappedCallback);
        for (Object module : this.pluginAccessor.getEnabledModulesByClass(type)) {
            callback.apply(module);
        }
        return new Closeable((Function)wrappedCallback){
            final /* synthetic */ Function val$wrappedCallback;
            {
                this.val$wrappedCallback = function;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                PluginModuleServiceListener pluginModuleServiceListener = PluginModuleServiceListener.this;
                synchronized (pluginModuleServiceListener) {
                    PluginModuleServiceListener.this.listeners.remove(this.val$wrappedCallback);
                }
            }
        };
    }

    @PluginEventListener
    public void pluginEnabledEvent(PluginEnabledEvent event) {
        for (Function<Plugin, Void> listener : this.listeners) {
            listener.apply((Object)event.getPlugin());
        }
    }

    public void destroy() throws Exception {
        this.pluginEventManager.unregister((Object)this);
    }
}

