/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.log4j;

import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.MultiTenantCreator;
import com.atlassian.multitenant.MultiTenantDestroyer;
import com.atlassian.multitenant.Tenant;
import java.io.File;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;

public class MultiTenantHomeAppender
extends WriterAppender {
    private static final Logger log = Logger.getLogger(MultiTenantHomeAppender.class);
    private static final String DEFAULT_LOG_NAME = "atlassian.log";
    private static final String LOGS_DIR = "logs";
    private volatile Layout layout;
    private volatile String maxFileSize;
    private volatile int maxBackupIndex;
    private volatile String logFileName;
    private volatile boolean activated;
    private volatile MultiTenantComponentMap<RollingFileAppender> map;
    private final ConsoleAppender consoleAppender = new ConsoleAppender();

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.consoleAppender.setLayout(layout);
        this.layout = layout;
    }

    public void close() {
        this.consoleAppender.close();
        this.activated = false;
        for (RollingFileAppender appender : this.map.getAll()) {
            appender.close();
        }
    }

    public void append(LoggingEvent event) {
        if (this.map != null && MultiTenantContext.getTenantReference().isSet() && this.map.isInitialised()) {
            RollingFileAppender appender = (RollingFileAppender)this.map.get();
            if (appender == null) {
                this.consoleAppender.append(event);
            } else {
                ((RollingFileAppender)this.map.get()).append(event);
            }
        } else {
            this.consoleAppender.append(event);
        }
    }

    public synchronized void initialise() {
        if (this.map != null) {
            throw new IllegalStateException("Initialised called twice");
        }
        this.map = MultiTenantContext.getFactory().createComponentMapBuilder((MultiTenantCreator)new RollingFileAppenderCreator()).setLazyLoad(MultiTenantComponentMap.LazyLoadStrategy.EAGER_LOAD).construct();
    }

    public void activateOptions() {
        this.consoleAppender.activateOptions();
        this.activated = true;
        if (this.map != null) {
            this.map.initialiseAll();
        }
    }

    public String getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public void setMaxBackupIndex(int maxBackupIndex) {
        this.maxBackupIndex = maxBackupIndex;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RollingFileAppenderCreator
    implements MultiTenantCreator<RollingFileAppender>,
    MultiTenantDestroyer<RollingFileAppender> {
        private RollingFileAppenderCreator() {
        }

        public RollingFileAppender create(Tenant tenant) {
            if (MultiTenantHomeAppender.this.activated) {
                String logsLocation = tenant.getHomeDir() + File.separator + MultiTenantHomeAppender.LOGS_DIR;
                File logDirectory = new File(logsLocation);
                if (!logDirectory.exists() && !logDirectory.mkdir()) {
                    log.error((Object)("Could not create logs directory " + logsLocation + ". Logging remains directed to the ConsoleAppender."));
                    return null;
                }
                if (MultiTenantHomeAppender.this.logFileName == null) {
                    MultiTenantHomeAppender.this.logFileName = MultiTenantHomeAppender.DEFAULT_LOG_NAME;
                }
                String logFile = logsLocation + File.separator + MultiTenantHomeAppender.this.logFileName;
                RollingFileAppender appender = new RollingFileAppender();
                if (MultiTenantHomeAppender.this.maxBackupIndex != 0) {
                    appender.setMaxBackupIndex(MultiTenantHomeAppender.this.maxBackupIndex);
                }
                if (MultiTenantHomeAppender.this.maxFileSize != null) {
                    appender.setMaxFileSize(MultiTenantHomeAppender.this.maxFileSize);
                }
                appender.setFile(logFile);
                appender.activateOptions();
                return appender;
            }
            return null;
        }

        public void destroy(Tenant tenant, RollingFileAppender instance) {
            instance.close();
        }
    }
}

