/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.hibernate2;

import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.MultiTenantCreator;
import com.atlassian.multitenant.MultiTenantDestroyer;
import com.atlassian.multitenant.Tenant;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.CacheProvider;
import net.sf.hibernate.cache.EhCacheProvider;
import net.sf.hibernate.cache.Timestamper;
import org.apache.log4j.Logger;

public class MultiTenantEhCacheProvider
implements CacheProvider {
    private static final Logger log;
    private final MultiTenantComponentMap<CacheProvider> map = MultiTenantContext.getFactory().createComponentMap((MultiTenantCreator)new CacheProviderCreator());
    private volatile boolean started;
    private volatile Properties properties;
    private static final Set<Method> INVOKE_FOR_ALL_METHODS;

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        return (Cache)MultiTenantContext.getFactory().createComponent(MultiTenantContext.getFactory().createComponentMap((MultiTenantCreator)new CacheCreator(regionName, properties)), INVOKE_FOR_ALL_METHODS, Cache.class);
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public synchronized void start(Properties properties) throws CacheException {
        this.properties = properties;
        for (CacheProvider cacheProvider : this.map.getAll()) {
            cacheProvider.start(properties);
        }
        this.started = true;
    }

    public synchronized void stop() {
        this.started = false;
        for (CacheProvider cacheProvider : this.map.getAll()) {
            cacheProvider.stop();
        }
    }

    static {
        Set<Method> methods;
        log = Logger.getLogger(MultiTenantEhCacheProvider.class);
        try {
            methods = Collections.singleton(Cache.class.getDeclaredMethod("destroy", new Class[0]));
        }
        catch (NoSuchMethodException nsme) {
            log.fatal((Object)"Could not find destroy method on Hibernate Cache class", (Throwable)nsme);
            methods = Collections.emptySet();
        }
        INVOKE_FOR_ALL_METHODS = methods;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CacheCreator
    implements MultiTenantCreator<Cache>,
    MultiTenantDestroyer<Cache> {
        private final String regionName;
        private final Properties properties;

        private CacheCreator(String regionName, Properties properties) {
            this.regionName = regionName;
            this.properties = properties;
        }

        public Cache create(Tenant tenant) {
            try {
                return ((CacheProvider)MultiTenantEhCacheProvider.this.map.get()).buildCache(this.regionName, this.properties);
            }
            catch (CacheException ce) {
                throw new RuntimeException("Unable to create cache", ce);
            }
        }

        public void destroy(Tenant tenant, Cache instance) {
            try {
                instance.destroy();
            }
            catch (CacheException ce) {
                throw new RuntimeException("Unable to destroy cache", ce);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CacheProviderCreator
    implements MultiTenantCreator<CacheProvider>,
    MultiTenantDestroyer<CacheProvider> {
        private CacheProviderCreator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CacheProvider create(Tenant tenant) {
            MultiTenantEhCacheProvider multiTenantEhCacheProvider = MultiTenantEhCacheProvider.this;
            synchronized (multiTenantEhCacheProvider) {
                EhCacheProvider cacheProvider = new EhCacheProvider();
                if (MultiTenantEhCacheProvider.this.started) {
                    try {
                        cacheProvider.start(MultiTenantEhCacheProvider.this.properties);
                    }
                    catch (CacheException ce) {
                        throw new RuntimeException("Error starting cache", ce);
                    }
                }
                return cacheProvider;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy(Tenant tenant, CacheProvider instance) {
            MultiTenantEhCacheProvider multiTenantEhCacheProvider = MultiTenantEhCacheProvider.this;
            synchronized (multiTenantEhCacheProvider) {
                if (MultiTenantEhCacheProvider.this.started) {
                    instance.stop();
                }
            }
        }
    }
}

