/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTenantCacheManager
implements CacheManager {
    private final CacheManager cacheManager;
    private final Map<String, Cache> caches = CopyOnWriteMap.newHashMap();
    private final Set<Object> sharedCaches;

    public MultiTenantCacheManager(CacheManager cacheManager, Set<Object> sharedCaches) {
        this.cacheManager = cacheManager;
        this.sharedCaches = sharedCaches;
    }

    public Collection getCaches() {
        return this.caches.values();
    }

    public void flushCaches() {
        this.cacheManager.flushCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache(String name) {
        Object cache = this.caches.get(name);
        if (cache == null) {
            MultiTenantCacheManager multiTenantCacheManager = this;
            synchronized (multiTenantCacheManager) {
                if (!this.caches.containsKey(name)) {
                    cache = this.sharedCaches.contains(name) ? this.cacheManager.getCache(name) : new MultiTenantCache(name);
                    this.caches.put(name, (Cache)cache);
                }
            }
        }
        return cache;
    }

    private class MultiTenantCache
    implements Cache {
        private final String name;

        private MultiTenantCache(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private Cache getCache() {
            return MultiTenantCacheManager.this.cacheManager.getCache(this.name);
        }

        public Collection getKeys() {
            if (MultiTenantContext.getTenantReference().isSet()) {
                return this.getCache().getKeys();
            }
            return Collections.emptySet();
        }

        public Object get(Object key) {
            if (MultiTenantContext.getTenantReference().isSet()) {
                return this.getCache().get(key);
            }
            return null;
        }

        public void put(Object key, Object value) {
            if (MultiTenantContext.getTenantReference().isSet()) {
                this.getCache().put(key, value);
            }
        }

        public void remove(Object key) {
            if (MultiTenantContext.getTenantReference().isSet()) {
                this.getCache().remove(key);
            }
        }

        public void removeAll() {
            if (MultiTenantContext.getTenantReference().isSet()) {
                this.getCache().removeAll();
            }
        }
    }
}

