/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.impl;

import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.MultiTenantCreator;
import com.atlassian.multitenant.MultiTenantDestroyer;
import com.atlassian.multitenant.MultiTenantManager;
import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.TenantReference;
import com.atlassian.multitenant.impl.TenantComponentMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTenantComponentMapImpl<C>
implements MultiTenantComponentMap<C> {
    private final TenantReference tenantReference;
    private final MultiTenantManager manager;
    private MultiTenantCreator<C> creator;
    private MultiTenantDestroyer<C> destroyer;
    private MultiTenantComponentMap.LazyLoadStrategy lazyLoadStrategy = MultiTenantComponentMap.LazyLoadStrategy.LAZY_LOAD;
    private MultiTenantComponentMap.NoTenantStrategy strategy = MultiTenantComponentMap.NoTenantStrategy.FAIL;

    MultiTenantComponentMapImpl(MultiTenantCreator<C> creator, TenantReference tenantReference, MultiTenantManager manager) {
        this.creator = creator;
        this.tenantReference = tenantReference;
        this.manager = manager;
        if (creator instanceof MultiTenantDestroyer) {
            this.destroyer = (MultiTenantDestroyer)((Object)creator);
        }
    }

    void init() {
        if (this.lazyLoadStrategy == MultiTenantComponentMap.LazyLoadStrategy.EAGER_LOAD) {
            this.initialiseAll();
        }
    }

    private TenantComponentMap getTenant() {
        return this.castTenant(this.tenantReference.get());
    }

    private TenantComponentMap castTenant(Tenant tenant) {
        if (tenant instanceof TenantComponentMap) {
            return (TenantComponentMap)tenant;
        }
        throw new IllegalStateException("Tenant is not a component map tenant!");
    }

    @Override
    public C get() {
        TenantComponentMap tenant = this.strategy == MultiTenantComponentMap.NoTenantStrategy.FAIL ? this.getTenant() : (this.tenantReference.isSet() ? this.getTenant() : (TenantComponentMap)MultiTenantContext.getSystemTenant());
        return this.get(tenant);
    }

    @Override
    public Collection<C> getAll() {
        ArrayList components = new ArrayList();
        for (Tenant tenant : this.manager.getAllTenants()) {
            Object component = this.castTenant(tenant).getObject(this);
            if (component == null) continue;
            components.add(component);
        }
        return components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C get(TenantComponentMap tenant) {
        if (!tenant.hasObject(this)) {
            MultiTenantComponentMapImpl multiTenantComponentMapImpl = this;
            synchronized (multiTenantComponentMapImpl) {
                if (!tenant.hasObject(this)) {
                    if (this.creator == null) {
                        throw new IllegalStateException("No implementation has been registered for this tenant, and there's no creator to create it");
                    }
                    C value = this.creator.create(tenant);
                    tenant.putObject(this, value);
                }
            }
        }
        return (C)tenant.getObject(this);
    }

    @Override
    public void initialiseAll() {
        for (Tenant tenant : this.manager.getAllTenants()) {
            this.get(this.castTenant(tenant));
        }
    }

    @Override
    public void destroy() {
        this.creator = null;
        for (Tenant tenant : this.manager.getAllTenants()) {
            this.onTenantStop(tenant);
        }
        this.manager.deregisterListener(this);
    }

    @Override
    public boolean isInitialised() {
        TenantComponentMap tenant = this.getTenant();
        return tenant.hasObject(this);
    }

    @Override
    public void addInstance(C object) {
        TenantComponentMap tenant = this.getTenant();
        tenant.putObject(this, object);
    }

    @Override
    public void onTenantStart(Tenant tenant) {
        if (this.lazyLoadStrategy != MultiTenantComponentMap.LazyLoadStrategy.LAZY_LOAD) {
            this.get(this.castTenant(tenant));
        }
    }

    @Override
    public void onTenantStop(Tenant tenant) {
        TenantComponentMap tenantMap = this.castTenant(tenant);
        Object component = tenantMap.getObject(this);
        if (component != null) {
            if (this.destroyer != null) {
                this.destroyer.destroy(tenant, component);
            }
            tenantMap.removeObject(this);
        }
    }

    void setDestroyer(MultiTenantDestroyer<C> destroyer) {
        this.destroyer = destroyer;
    }

    void setLazyLoad(MultiTenantComponentMap.LazyLoadStrategy lazyLoadStrategy) {
        this.lazyLoadStrategy = lazyLoadStrategy;
    }

    void setNoInstanceStrategy(MultiTenantComponentMap.NoTenantStrategy strategy) {
        this.strategy = strategy;
    }

    public String toString() {
        if (this.creator == null) {
            return "Destroyed map";
        }
        for (Type type : this.creator.getClass().getGenericInterfaces()) {
            Type[] params;
            ParameterizedType paramType;
            if (!(type instanceof ParameterizedType) || !(paramType = (ParameterizedType)type).getRawType().equals(MultiTenantCreator.class) || (params = paramType.getActualTypeArguments()).length <= 0 || !(params[0] instanceof Class)) continue;
            return "Multi-Tenant component map of " + ((Class)params[0]).getName();
        }
        return "Multi-Tenant component map with creator: " + this.creator.toString();
    }
}

