package com.atlassian.multitenant.servlet;

import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.TenantReference;
import org.apache.log4j.Logger;

import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

/**
 * Sets the current tenant in the session, to protect against session fixation
 */
public class MultiTenantSessionListener implements HttpSessionListener
{
    private static final Logger log = Logger.getLogger(MultiTenantSessionListener.class);

    public void sessionCreated(final HttpSessionEvent httpSessionEvent)
    {
        TenantReference tenantReference = MultiTenantContext.getTenantReference();
        if (!tenantReference.isSet())
        {
            log.warn("Session created without a tenant being set");
        }
        else
        {
            Tenant tenant = tenantReference.get();
            httpSessionEvent.getSession().setAttribute(MultiTenantServletFilter.TENANT_SESSION_KEY, tenant.getName());
        }
    }

    public void sessionDestroyed(final HttpSessionEvent httpSessionEvent)
    {
    }
}
