package com.atlassian.multitenant.impl.matchers;

import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.MultiTenantMatcher;
import com.atlassian.multitenant.impl.MultiTenantDatastore;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Matches a tenant based on the hostname.  This is the way tenants will most commonly get matched in production.
 */
public class HostnameMatcher implements MultiTenantMatcher
{
    private final MultiTenantDatastore datastore;

    public HostnameMatcher(final MultiTenantDatastore datastore)
    {
        this.datastore = datastore;
    }

    public Tenant getTenantForRequest(final HttpServletRequest request, HttpServletResponse response)
    {
        String hostname = request.getServerName();
        return datastore.getByHostname(hostname);
    }
}
