package com.atlassian.multitenant.impl.datastore;

import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.impl.MultiTenantDatastore;
import com.atlassian.multitenant.impl.MultiTenantParser;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;

/**
 * Empty datastore.  Can be used for single tenant situations, in combination with the system tenant datastore.
 */
public class EmptyDatastore implements MultiTenantDatastore, MultiTenantParser
{
    public Tenant get(final String name)
    {
        return null;
    }

    public Collection<Tenant> getAll()
    {
        return Collections.emptyList();
    }

    public Tenant getByHostname(final String hostname)
    {
        return null;
    }

    public void addTenant(final Tenant tenant)
    {
        throw new UnsupportedOperationException("Empty datastore is immutable");
    }

    public void removeTenant(final Tenant tenant)
    {
        throw new UnsupportedOperationException("Empty datastore is immutable");
    }

    public Tenant parseTenant(final Reader reader) throws IOException
    {
        throw new UnsupportedOperationException("Empty datastore doesn't parse");
    }
}
