package com.atlassian.multitenant.impl;

import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.TenantReference;

/**
 * The system tenant reference is a tenant reference for single tenant mode, and it just returns the system tenant.
 */
public class SystemTenantReference implements TenantReference
{
    public Tenant get()
    {
        return MultiTenantContext.getSystemTenant();
    }

    public boolean isSet()
    {
        return true;
    }

    public void set(final Tenant tenant, final boolean allowOverride) throws IllegalStateException
    {
    }

    public void remove() throws IllegalStateException
    {
    }
}
