package com.atlassian.multitenant.impl;

import com.atlassian.multitenant.MultiTenantComponentMapBuilder;
import com.atlassian.multitenant.MultiTenantCreator;
import com.atlassian.multitenant.MultiTenantDestroyer;
import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.TenantReference;
import com.atlassian.multitenant.MultiTenantManager;

/**
 * Builder implementation
 */
public class MultiTenantComponentMapBuilderImpl<C> implements MultiTenantComponentMapBuilder<C>
{
    private MultiTenantComponentMapImpl<C> map;
    private MultiTenantComponentMap.Registration registrationStrategy = MultiTenantComponentMap.Registration.YES;
    private final MultiTenantManager manager;

    MultiTenantComponentMapBuilderImpl(MultiTenantCreator<C> creator, TenantReference tenantReference,
            MultiTenantManager manager)
    {
        this.manager = manager;
        map = new MultiTenantComponentMapImpl<C>(creator, tenantReference, manager);
    }

    public MultiTenantComponentMapBuilder<C> setDestroyer(final MultiTenantDestroyer<C> destroyer)
    {
        map.setDestroyer(destroyer);
        return this;
    }

    public MultiTenantComponentMapBuilder<C> setLazyLoad(final MultiTenantComponentMap.LazyLoadStrategy lazyLoadStrategy)
    {
        map.setLazyLoad(lazyLoadStrategy);
        return this;
    }

    public MultiTenantComponentMapBuilder<C> setNoTenantStrategy(final MultiTenantComponentMap.NoTenantStrategy strategy)
    {
        map.setNoInstanceStrategy(strategy);
        return this;
    }

    public MultiTenantComponentMapBuilder<C> registerListener(final MultiTenantComponentMap.Registration choice)
    {
        registrationStrategy = choice;
        return this;
    }

    public MultiTenantComponentMap<C> construct()
    {
        // We don't want the builder to be able to be used to mutate the map after its construction, so we set it to
        // null before returning the variable
        MultiTenantComponentMapImpl<C> result = map;
        map = null;
        result.init();
        if (registrationStrategy == MultiTenantComponentMap.Registration.YES)
        {
            manager.registerListener(result);
        }
        return result;

    }
}
