package com.atlassian.multitenant.impl;

import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.MultiTenantMatcher;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Default matcher for matching requests to tenants
 */
public class DefaultMultiTenantMatcher implements MultiTenantMatcher
{
    private final Collection<MultiTenantMatcher> matchers;

    public DefaultMultiTenantMatcher(final Collection<MultiTenantMatcher> matchers)
    {
        this.matchers = matchers;
    }

    public Tenant getTenantForRequest(final HttpServletRequest request, HttpServletResponse response)
    {
        for (MultiTenantMatcher matcher : matchers)
        {
            Tenant tenant = matcher.getTenantForRequest(request, response);
            if (tenant != null)
            {
                return tenant;
            }
        }
        return null;
    }
}
