package com.atlassian.multitenant;

/**
 * Controller for the lifecycle of tenants
 */
public interface MultiTenantLifecycleController
{
    /**
     * Start the given tenant
     *
     * @param tenant The tenant to start
     */
    void addTenant(Tenant tenant);

    /**
     * Stop the given tenant
     *
     * @param tenantName The name of the tenant to stop
     */
    void removeTenant(String tenantName);

    /**
     * Start all tenants
     */
    void startAll();

    /**
     * Stop all tenants
     */
    void stopAll();

    /**
     * Refresh the given tenant
     *
     * @param tenant The tenant to refresh
     */
    void refreshTenant(Tenant tenant);
}
