package com.atlassian.multitenant;

/**
 * Listener interface for multi tenant lifecycle events
 */
public interface MultiTenantLifecycleAware
{
    /**
     * Called when a tenant starts
     *
     * @param tenant The tenant that started
     */
    void onTenantStart(Tenant tenant);

    /**
     * Called when a tenant stops
     *
     * @param tenant The tenant that stopped
     */
    void onTenantStop(Tenant tenant);
}
