package com.atlassian.multitenant;

/**
 * This interface is used by the {@link MultiTenantComponentMap} to dispose of instances of a component when a tenant is
 * shut down.
 */
public interface MultiTenantDestroyer<C>
{
    /**
     * Destroy the given instance
     *
     * @param tenant The tenant being shut down
     * @param instance The instance associated with that tenant
     */
    void destroy(Tenant tenant, C instance);
}
