package com.atlassian.multitenant;

/**
 * This interface is used by the {@link MultiTenantComponentMap} to create new instances of a component when required.
 */
public interface MultiTenantCreator<C>
{
    /**
     * Create a new component for the given tenant
     *
     * @param tenant The tenant to create the component for
     * @return The component
     */
    C create(Tenant tenant);
}
