/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.user;

import com.atlassian.migration.agent.okhttp.ErrorResponse;
import com.atlassian.migration.agent.service.user.UserMigrationStatus;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UsersMigrationStatusResponse {
    @JsonProperty
    private final String taskId;
    @JsonProperty
    private final int progressPercentage;
    @JsonProperty
    private final UserMigrationStatus status;
    @JsonProperty
    private final List<ErrorResponse> errors;

    @JsonCreator
    public UsersMigrationStatusResponse(@JsonProperty(value="taskId") String taskId, @JsonProperty(value="progressPercentage") int progressPercentage, @JsonProperty(value="status") UserMigrationStatus status, @JsonProperty(value="errors") List<ErrorResponse> errors) {
        this.taskId = Objects.requireNonNull(taskId);
        this.progressPercentage = progressPercentage;
        this.status = status;
        this.errors = errors;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public int getProgressPercentage() {
        return this.progressPercentage;
    }

    public UserMigrationStatus getStatus() {
        return this.status;
    }

    public boolean isSuccessful() {
        return this.status == UserMigrationStatus.DONE;
    }

    public boolean isComplete() {
        return this.status != UserMigrationStatus.IN_PROGRESS;
    }

    public Optional<String> getFirstErrorMessage() {
        return this.errors.stream().map(error -> error.message).findFirst();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE);
    }
}

