/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.user;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.queue.QueueConsumer;
import com.atlassian.migration.agent.queue.QueueConsumerConfiguration;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.impl.UserService;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepExecutionException;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.StepSchedulerService;
import com.atlassian.migration.agent.service.user.RetryingUsersMigrationService;
import com.atlassian.migration.agent.service.user.UsersMigrationRequest;
import com.atlassian.migration.agent.service.user.UsersMigrationRequestBuilder;
import com.atlassian.migration.agent.service.user.UsersMigrationService;
import com.atlassian.migration.agent.service.user.UsersMigrationStatusResponse;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.app.AppMigrationServiceClient;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;

@Singleton
@ParametersAreNonnullByDefault
public class UsersMigrationExecutor
implements QueueConsumer,
JobRunner {
    private static final Logger log = ContextLoggerFactory.getLogger(UsersMigrationExecutor.class);
    private static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)"migration-plugin:users-migrate-progress-tracker");
    private static final Duration POLLING_PERIOD = Duration.ofSeconds(5L);
    private static final String TASK_ID_JOB_PARAM = "taskId";
    private static final String STEP_ID_JOB_PARAM = "stepId";
    private final StepSchedulerService stepSchedulerService;
    private final SchedulerService schedulerService;
    private final CloudSiteService cloudSiteService;
    private final UsersMigrationService usersMigrationService;
    private final ProgressTracker progressTracker;
    private final UserService userService;
    private final AppMigrationServiceClient appMigrationServiceClient;
    private final StepStore stepStore;
    private final UsersMigrationRequestBuilder usersMigrationRequestBuilder;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    @Inject
    UsersMigrationExecutor(StepSchedulerService stepSchedulerService, SchedulerService schedulerService, CloudSiteService cloudSiteService, RetryingUsersMigrationService usersMigrationService, ProgressTracker progressTracker, UsersMigrationRequestBuilder usersMigrationRequestBuilder, AppMigrationServiceClient appMigrationServiceClient, StepStore stepStore, UserService userService, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.schedulerService = schedulerService;
        this.stepSchedulerService = stepSchedulerService;
        this.cloudSiteService = cloudSiteService;
        this.usersMigrationService = usersMigrationService;
        this.progressTracker = progressTracker;
        this.userService = userService;
        this.appMigrationServiceClient = appMigrationServiceClient;
        this.stepStore = stepStore;
        this.usersMigrationRequestBuilder = usersMigrationRequestBuilder;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    @PostConstruct
    public void initialize() {
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
    }

    @PreDestroy
    public void cleanup() {
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
    }

    @Override
    public QueueConsumerConfiguration getConsumerConfiguration() {
        return QueueConsumerConfiguration.builder(StepType.USERS_MIGRATION.name()).withConcurrencyLevel(1).build();
    }

    @Override
    public void consume(String stepId, String jobId) {
        this.stepSchedulerService.consumeStep(stepId, StepType.USERS_MIGRATION, () -> this.consumeStep(stepId, jobId));
    }

    @VisibleForTesting
    Optional<StepResult> consumeStep(String stepId, String jobId) {
        UsersMigrationRequest request = this.buildUserMigrationRequest();
        String taskId = this.initiateUsersAndGroupsImport(stepId, request);
        ImmutableMap jobParams = ImmutableMap.of((Object)STEP_ID_JOB_PARAM, (Object)stepId, (Object)TASK_ID_JOB_PARAM, (Object)taskId);
        Schedule schedule = Schedule.forInterval((long)POLLING_PERIOD.toMillis(), null);
        this.stepSchedulerService.scheduleStep(stepId, RUNNER_KEY, JobId.of((String)jobId), StepType.USERS_MIGRATION, (Map<String, Serializable>)jobParams, schedule);
        this.sendUserMappings(stepId);
        return Optional.empty();
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        String stepId = (String)request.getJobConfig().getParameters().get(STEP_ID_JOB_PARAM);
        String taskId = (String)request.getJobConfig().getParameters().get(TASK_ID_JOB_PARAM);
        this.stepSchedulerService.runScheduledStep(request.getJobId(), StepType.USERS_MIGRATION, stepId, () -> this.doProgressCheck(stepId, taskId));
        return JobRunnerResponse.success();
    }

    @VisibleForTesting
    String initiateUsersAndGroupsImport(String stepId, UsersMigrationRequest request) {
        String containerToken = this.cloudSiteService.getByStepId(stepId).getContainerToken();
        String taskId = this.usersMigrationService.initiateUsersAndGroupsMigration(containerToken, request);
        log.info("Initiated users and groups import task for {} users and {} groups. taskId: {}", new Object[]{request.getUsers().size(), request.getGroups().size(), taskId});
        return taskId;
    }

    @VisibleForTesting
    Optional<StepResult> doProgressCheck(String stepId, String taskId) {
        String containerToken = this.cloudSiteService.getByStepId(stepId).getContainerToken();
        ExecutionStatus planStatus = this.stepStore.getStep(stepId).getPlan().getProgress().getStatus();
        if (planStatus == ExecutionStatus.STOPPING || planStatus == ExecutionStatus.STOPPED) {
            this.usersMigrationService.cancelUsersAndGroupsMigration(containerToken, taskId);
            return Optional.of(StepResult.stopped());
        }
        UsersMigrationStatusResponse response = this.usersMigrationService.getUsersAndGroupsMigrationProgress(containerToken, taskId);
        log.debug("Got progress for task {}: {}", (Object)taskId, (Object)response);
        if (!response.isComplete()) {
            log.debug("Users and groups migration to cloud is still going. Updated progress for task {} to {}.", (Object)taskId, (Object)response.getProgressPercentage());
            this.progressTracker.progress(stepId, response.getProgressPercentage(), "Migrating users and groups");
            return Optional.empty();
        }
        if (!response.isSuccessful()) {
            throw new StepExecutionException(response.getFirstErrorMessage().orElse("Unknown error"));
        }
        return Optional.of(StepResult.succeeded("Users and groups migration complete"));
    }

    @VisibleForTesting
    UsersMigrationRequest buildUserMigrationRequest() {
        try {
            return this.usersMigrationRequestBuilder.createUsersMigrationRequest();
        }
        catch (Exception e) {
            throw new StepExecutionException("Couldn't retrieve entities to build request", e);
        }
    }

    private void sendUserMappings(String stepId) {
        if (this.migrationDarkFeaturesManager.appMigrationEnabled()) {
            List<MigrationUser> allUsers = this.userService.getAllUsers();
            Plan plan = this.stepStore.getStep(stepId).getPlan();
            this.appMigrationServiceClient.addMapping(plan.getCloudSite().getCloudId(), plan.getId(), "user.username", allUsers.stream().collect(Collectors.toMap(migrationUser -> migrationUser.getUsername(), MigrationUser::getEmail)));
        }
    }
}

