/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.attachment;

import com.atlassian.migration.agent.entity.Attachment;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.logging.LoggingContextBuilder;
import com.atlassian.migration.agent.media.MediaFileUploader;
import com.atlassian.migration.agent.media.MediaFileUploaderFactory;
import com.atlassian.migration.agent.service.AttachmentService;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentDataProvider;
import com.atlassian.migration.agent.store.AttachmentMigrationCandidate;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;

@Singleton
public class AttachmentMigrator {
    private static final Logger log = ContextLoggerFactory.getLogger(AttachmentMigrator.class);
    private final AttachmentService attachmentService;
    private final MediaFileUploaderFactory mediaFileUploaderFactory;
    private final AttachmentDataProvider attachmentDataProvider;

    @Inject
    AttachmentMigrator(AttachmentService attachmentService, MediaFileUploaderFactory mediaFileUploaderFactory, AttachmentDataProvider attachmentDataProvider) {
        this.attachmentService = attachmentService;
        this.mediaFileUploaderFactory = mediaFileUploaderFactory;
        this.attachmentDataProvider = attachmentDataProvider;
    }

    public boolean migrate(AttachmentMigrationCandidate attachmentCandidate, CloudSite cloudSite, MediaFileUploader.Tracker uploadTracker) {
        return this.attachmentNeedsMigration(attachmentCandidate) && this.upload(attachmentCandidate.getAttachment(), cloudSite, uploadTracker);
    }

    private boolean attachmentNeedsMigration(AttachmentMigrationCandidate attachment) {
        if (attachment.hasNeverMigrated()) {
            log.info("Attachment {} has never migrated.", (Object)attachment.getAttachment().getId());
            return true;
        }
        if (attachment.isVersionChanged()) {
            log.info("Remigrating attachment {} due to version update", (Object)attachment.getAttachment().getId());
            return true;
        }
        log.info("Attachment {} attachment needs migration: {}", (Object)attachment.getAttachment().getId(), (Object)false);
        return false;
    }

    private boolean upload(Attachment attachment, CloudSite cloudSite, MediaFileUploader.Tracker progressTracker) {
        return LoggingContextBuilder.logCtx().withAttachment(attachment).execute(() -> this.uploadImpl(attachment, cloudSite, progressTracker));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean uploadImpl(Attachment attachment, CloudSite cloudSite, MediaFileUploader.Tracker uploadTracker) {
        log.info("Start upload of attachment");
        MediaFileUploader mediaFileUploader = this.mediaFileUploaderFactory.create(cloudSite.getContainerToken());
        long attachmentId = attachment.getId();
        try (AttachmentDataProvider.AttachmentData attachmentData = this.attachmentDataProvider.getAttachmentData(attachmentId);){
            String mediaId = mediaFileUploader.upload(attachmentData.inputStream, attachmentData.fileName, uploadTracker);
            log.info("Attachment Id: {} uploaded with filename: {} with mediaId: {}", new Object[]{attachmentId, attachmentData.fileName, mediaId});
            this.attachmentService.logSuccessfulAttachmentMigration(cloudSite, attachment, mediaId);
            boolean bl = true;
            return bl;
        }
        catch (AttachmentDataProvider.AttachmentDataRetrievalException ex) {
            log.warn("Failed to read attachment {} data. The error is unrecoverable. The attachment will be marked as broken and will not be retried.", (Object)attachmentId, (Object)ex);
            this.attachmentService.logFailedAttachmentMigration(cloudSite, attachment);
            return false;
        }
    }
}

