/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.ExportDirManager;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;

@Singleton
@ParametersAreNonnullByDefault
public class DefaultExportDirManager
implements ExportDirManager {
    private static final Logger log = ContextLoggerFactory.getLogger(DefaultExportDirManager.class);
    private final BootstrapManager bootstrapManager;

    @Inject
    public DefaultExportDirManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    @Override
    public Path getExportFilePath(String fileId) {
        return this.getExportPath().resolve(fileId);
    }

    @Override
    public void moveExportedFileToSharedHome(String exportedFile, String destinationFileName) {
        try {
            Files.move(Paths.get(exportedFile, new String[0]), this.getExportFilePath(destinationFileName), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String consumeExportFileSafely(String fileId, Function<File, String> fileConsumer) {
        try {
            File exportFile = this.getValidExportFile(fileId);
            String string = fileConsumer.apply(exportFile);
            return string;
        }
        finally {
            this.cleanupExportFile(fileId);
        }
    }

    @VisibleForTesting
    File validateExportFile(File exportFile) {
        if (!exportFile.isFile()) {
            throw new IllegalArgumentException("Export file is not a file.");
        }
        if (!exportFile.canRead()) {
            throw new IllegalArgumentException("Export file cannot be read.");
        }
        if (exportFile.length() <= 0L) {
            throw new IllegalArgumentException("Export file has no content.");
        }
        return exportFile;
    }

    private File getValidExportFile(String fileId) {
        return this.validateExportFile(this.getExportFilePath(fileId).toFile());
    }

    private Path getExportPath() {
        return Paths.get(this.bootstrapManager.getSharedHome().getAbsolutePath(), "migration", "exports");
    }

    private void cleanupExportFile(String fileId) {
        try {
            Files.delete(this.getExportFilePath(fileId));
        }
        catch (IOException e) {
            log.error("Failed to clean up export file. Reason: " + e.getMessage(), (Throwable)e);
        }
    }
}

