/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.ChecksResultDto;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.logging.LoggingContextBuilder;
import com.atlassian.migration.agent.rest.MessageDto;
import com.atlassian.migration.agent.service.check.CheckResultsService;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.PreflightService;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@Path(value="check")
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CheckResource {
    private static final Logger log = ContextLoggerFactory.getLogger(CheckResource.class);
    private final PreflightService preflightService;
    private final CheckResultsService checkResultService;

    public CheckResource(PreflightService preflightService, CheckResultsService checkResultService) {
        this.preflightService = preflightService;
        this.checkResultService = checkResultService;
    }

    @GET
    @Path(value="/{executionId}/status")
    public Response getCheckExecutionStatus(@PathParam(value="executionId") String executionId) {
        return LoggingContextBuilder.logCtx().withCheckExecutionId(executionId).execute(() -> {
            List<CheckResultDto> results = this.preflightService.getCheckExecutionStatus(executionId);
            if (results.isEmpty()) {
                log.warn("Check execution not found.");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new MessageDto(String.format("Check execution with id = %s not found", executionId))).build();
            }
            return Response.ok((Object)new ChecksResultDto(results)).build();
        });
    }

    @POST
    @Path(value="/{executionId}")
    public void executeChecks(@PathParam(value="executionId") String executionId, @QueryParam(value="type") Set<CheckType> types, PlanDto planDto) {
        LoggingContextBuilder.logCtx().withCheckExecutionId(executionId).execute(() -> this.preflightService.executeChecks(executionId, planDto, types));
    }

    @DELETE
    @Path(value="/{executionId}")
    public void deleteCheckExecutionResults(@PathParam(value="executionId") String executionId) {
        LoggingContextBuilder.logCtx().withCheckExecutionId(executionId).execute(() -> {
            this.checkResultService.deleteCheckResultsByExecutionId(executionId);
            log.info("Check execution is deleted.");
        });
    }
}

