/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.agent.dto.AppInstallInfoRequest;
import com.atlassian.migration.agent.dto.assessment.AppAssessmentUpdateRequest;
import com.atlassian.migration.agent.service.impl.AppAssessmentService;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="app")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ResourceFilters(value={AdminOnlyResourceFilter.class})
public class AppAssessmentResource {
    private final AppAssessmentService appAssessmentService;

    @Inject
    public AppAssessmentResource(AppAssessmentService appAssessmentService) {
        this.appAssessmentService = appAssessmentService;
    }

    @GET
    @Path(value="/")
    public Response getPluginInfo() {
        return Response.ok(this.appAssessmentService.getPlugins()).build();
    }

    @GET
    @Path(value="/stats")
    public Response getPluginStats() {
        return Response.ok((Object)this.appAssessmentService.getPluginStats()).build();
    }

    @POST
    @Path(value="/update")
    public Response updateMigrationStatus(AppAssessmentUpdateRequest updateRequest) {
        this.appAssessmentService.updateMigrationStatus(updateRequest.getAppKey(), updateRequest);
        return Response.ok().build();
    }

    @GET
    @Path(value="/usage")
    public Response getAppUsageStats() {
        return Response.ok(this.appAssessmentService.getAppUsageStats()).build();
    }

    @POST
    @Path(value="/usage/clearAppUsageCache")
    public Response clearAppUsageCache() {
        return Response.ok((Object)this.appAssessmentService.clearAppUsageCache()).build();
    }

    @POST
    @Path(value="/siteinfo")
    public Response getAppInstallationInfo(AppInstallInfoRequest request) {
        return Response.ok(this.appAssessmentService.getCloudAppsInfo(request)).build();
    }
}

