/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.dto.assessment;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum TrivalentState {
    yes,
    no,
    unknown;

    private static final Map<String, TrivalentState> featureDiff;
    private static final Map<String, TrivalentState> migratable;

    public static TrivalentState fromFeatureDifference(String rawString) {
        return featureDiff.getOrDefault(rawString, unknown);
    }

    public static TrivalentState fromMigratable(String rawString) {
        return migratable.getOrDefault(rawString, unknown);
    }

    static {
        featureDiff = ImmutableMap.of((Object)"HAS_DIFFERENCE", (Object)((Object)yes), (Object)"CONTACT_VENDOR", (Object)((Object)no), (Object)"UNKNOWN", (Object)((Object)unknown));
        migratable = ImmutableMap.of((Object)"YES", (Object)((Object)yes), (Object)"NO", (Object)((Object)no), (Object)"UNKNOWN", (Object)((Object)unknown));
    }
}

