/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import com.atlassian.migration.agent.service.impl.UserService;
import com.atlassian.migration.agent.service.version.ConfluenceServerVersion;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.jodah.failsafe.function.CheckedFunction;
import net.jodah.failsafe.function.CheckedRunnable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Singleton
class SpaceExportPostProcessor {
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceExportPostProcessor.class);
    private static final String GDPR_CONFLUENCE_VERSION = "6.14.0";
    private static final String ENTITIES_XML_ZIP_ENTRY_NAME = "entities.xml";
    private static final String EXPORT_DESCRIPTOR_ENTRY_NAME = "exportDescriptor.properties";
    private final UserService userService;
    private final boolean isGDPRReadyServer;
    private final XMLInputFactory inputFactory;
    private final XMLOutputFactory outputFactory;
    private final XMLEventFactory eventFactory;
    private final PluginVersionManager pluginVersionManager;

    @Inject
    public SpaceExportPostProcessor(UserService userService, SystemInformationService sysInfoService, PluginVersionManager pluginVersionManager) {
        this.userService = userService;
        this.pluginVersionManager = pluginVersionManager;
        this.isGDPRReadyServer = SpaceExportPostProcessor.isGDPRReadyServer(sysInfoService.getConfluenceInfo().getVersion());
        if (this.isGDPRReadyServer) {
            this.inputFactory = null;
            this.outputFactory = null;
            this.eventFactory = null;
        } else {
            this.inputFactory = XMLInputFactory.newFactory();
            this.outputFactory = XMLOutputFactory.newFactory();
            this.eventFactory = XMLEventFactory.newFactory();
            this.inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            this.inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            this.inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void postprocess(Path exportFile) {
        if (this.isGDPRReadyServer) {
            return;
        }
        Path modifiedExportFile = null;
        modifiedExportFile = Files.createTempFile(exportFile.getParent(), null, null, new FileAttribute[0]);
        try (ZipFile in = new ZipFile(exportFile.toFile());
             ZipOutputStream out = new ZipOutputStream(IOUtils.buffer((OutputStream)Files.newOutputStream(modifiedExportFile, new OpenOption[0])));){
            Enumeration<? extends ZipEntry> entries = in.entries();
            while (entries.hasMoreElements()) {
                InputStream entryInputStream;
                block40: {
                    ZipEntry entry = entries.nextElement();
                    out.putNextEntry(SpaceExportPostProcessor.copyEntry(entry));
                    entryInputStream = in.getInputStream(entry);
                    try {
                        if (ENTITIES_XML_ZIP_ENTRY_NAME.equals(entry.getName())) {
                            this.postprocessEntities(entryInputStream, out);
                            break block40;
                        }
                        if (EXPORT_DESCRIPTOR_ENTRY_NAME.equals(entry.getName())) {
                            this.postprocessDescriptor(entryInputStream, out);
                            break block40;
                        }
                        IOUtils.copy((InputStream)entryInputStream, (OutputStream)out);
                    }
                    catch (Throwable throwable) {
                        SpaceExportPostProcessor.runQuietly(entryInputStream::close);
                        throw throwable;
                    }
                }
                SpaceExportPostProcessor.runQuietly(entryInputStream::close);
                out.closeEntry();
            }
        }
        Files.move(modifiedExportFile, exportFile, StandardCopyOption.REPLACE_EXISTING);
        if (modifiedExportFile == null) return;
        try {
            Files.deleteIfExists(modifiedExportFile);
            return;
        }
        catch (IOException e) {
            log.warn("Couldn't delete temp file", (Throwable)e);
        }
        return;
        catch (Exception e) {
            try {
                log.error("Couldn't postprocess space export file", (Throwable)e);
                if (modifiedExportFile == null) return;
            }
            catch (Throwable throwable) {
                if (modifiedExportFile == null) throw throwable;
                try {
                    Files.deleteIfExists(modifiedExportFile);
                    throw throwable;
                }
                catch (IOException e2) {
                    log.warn("Couldn't delete temp file", (Throwable)e2);
                }
                throw throwable;
            }
            try {
                Files.deleteIfExists(modifiedExportFile);
                return;
            }
            catch (IOException e3) {
                log.warn("Couldn't delete temp file", (Throwable)e3);
            }
            return;
        }
    }

    @VisibleForTesting
    static boolean isGDPRReadyServer(String serverVersion) {
        return ConfluenceServerVersion.of(serverVersion).greaterOrEqual(GDPR_CONFLUENCE_VERSION);
    }

    private static ZipEntry copyEntry(ZipEntry original) {
        ZipEntry copy = new ZipEntry(original.getName());
        copy.setComment(original.getComment());
        copy.setExtra(original.getExtra());
        copy.setMethod(original.getMethod());
        copy.setTime(original.getTime());
        return copy;
    }

    private static boolean hasLocalName(StartElement element, String name) {
        return name.equals(element.getName().getLocalPart());
    }

    private static boolean hasLocalName(EndElement element, String name) {
        return name.equals(element.getName().getLocalPart());
    }

    private static boolean hasAttribute(StartElement elem, String attrName, String attrValue) {
        Iterator<Attribute> attrs = elem.getAttributes();
        while (attrs.hasNext()) {
            Attribute attr = attrs.next();
            if (!attrName.equals(attr.getName().getLocalPart()) || !attrValue.equals(attr.getValue())) continue;
            return true;
        }
        return false;
    }

    private static void runQuietly(CheckedRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            log.warn("Couldn't run operation quietly", (Throwable)e);
        }
    }

    private void addPropertyElement(XMLEventWriter writer, String propertyName, String cdata) throws XMLStreamException {
        QName propertyElementName = new QName("property");
        writer.add(this.eventFactory.createStartElement(propertyElementName, (Iterator<? extends Attribute>)Iterators.singletonIterator((Object)this.eventFactory.createAttribute("name", propertyName)), null));
        writer.add(this.eventFactory.createCData(cdata));
        writer.add(this.eventFactory.createEndElement(propertyElementName, null));
    }

    private EventProcessor processUserNameCData(boolean sawEmail, boolean sawFullName, ProcessingContext ctx) throws XMLStreamException {
        ctx.writer.add(ctx.event);
        if (ctx.event.isCharacters()) {
            return _ctx -> this.processUserProperty(ctx.event.asCharacters().getData(), sawEmail, sawFullName, (ProcessingContext)_ctx);
        }
        return _ctx -> this.processUserProperty(null, sawEmail, sawFullName, (ProcessingContext)_ctx);
    }

    private EventProcessor processUserProperty(String username, boolean sawEmail, boolean sawFullName, ProcessingContext ctx) throws XMLStreamException {
        ctx.writer.add(ctx.event);
        if (ctx.event.isStartElement()) {
            StartElement element = ctx.event.asStartElement();
            if (SpaceExportPostProcessor.hasAttribute(element, "name", "email")) {
                return _ctx -> this.processUserObject(username, true, sawFullName, (ProcessingContext)_ctx);
            }
            if (SpaceExportPostProcessor.hasAttribute(element, "name", "fullName")) {
                return _ctx -> this.processUserObject(username, sawEmail, true, (ProcessingContext)_ctx);
            }
            if (SpaceExportPostProcessor.hasAttribute(element, "name", "name")) {
                return _ctx -> this.processUserNameCData(sawEmail, sawFullName, (ProcessingContext)_ctx);
            }
        } else if (ctx.event.isEndElement() && SpaceExportPostProcessor.hasLocalName(ctx.event.asEndElement(), "property")) {
            return _ctx -> this.processUserObject(username, sawEmail, sawFullName, (ProcessingContext)_ctx);
        }
        return _ctx -> this.processUserProperty(username, sawEmail, sawFullName, (ProcessingContext)_ctx);
    }

    private EventProcessor processUserObject(String username, boolean sawEmail, boolean sawFullName, ProcessingContext ctx) throws XMLStreamException {
        if (ctx.event.isStartElement() && SpaceExportPostProcessor.hasLocalName(ctx.event.asStartElement(), "property")) {
            return this.processUserProperty(username, sawEmail, sawFullName, ctx);
        }
        if (ctx.event.isEndElement() && SpaceExportPostProcessor.hasLocalName(ctx.event.asEndElement(), "object")) {
            MigrationUser userInfo = ctx.usernamesToUsers.get(username);
            if (!sawEmail) {
                this.addPropertyElement(ctx.writer, "email", userInfo == null ? "" : userInfo.getEmail());
            }
            if (!sawFullName && userInfo != null && StringUtils.isNotBlank((CharSequence)userInfo.getFullName())) {
                this.addPropertyElement(ctx.writer, "fullName", userInfo.getFullName());
            }
            ctx.writer.add(ctx.event);
            return this::processUntilUserObject;
        }
        ctx.writer.add(ctx.event);
        return _ctx -> this.processUserObject(username, sawEmail, sawFullName, (ProcessingContext)_ctx);
    }

    private EventProcessor processUntilUserObject(ProcessingContext ctx) throws XMLStreamException {
        StartElement element;
        if (ctx.event.isStartElement() && SpaceExportPostProcessor.hasLocalName(element = ctx.event.asStartElement(), "object") && SpaceExportPostProcessor.hasAttribute(element, "class", "ConfluenceUserImpl")) {
            return this.processUserObject(null, false, false, ctx);
        }
        ctx.writer.add(ctx.event);
        return this::processUntilUserObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postprocessEntities(InputStream in, OutputStream out) throws Exception {
        XMLEventReader eventReader = null;
        XMLEventWriter eventWriter = null;
        try {
            eventReader = this.inputFactory.createXMLEventReader(in);
            eventWriter = this.outputFactory.createXMLEventWriter(out);
            Map<String, MigrationUser> usernamesToUsers = this.userService.getAllUsers().stream().collect(Collectors.toMap(MigrationUser::getUsername, Function.identity()));
            EventProcessor currentProcessor = this::processUntilUserObject;
            while (eventReader.hasNext()) {
                currentProcessor = (EventProcessor)currentProcessor.apply(new ProcessingContext(eventReader.nextEvent(), eventWriter, usernamesToUsers));
            }
        }
        finally {
            if (eventReader != null) {
                SpaceExportPostProcessor.runQuietly(eventReader::close);
            }
            if (eventWriter != null) {
                SpaceExportPostProcessor.runQuietly(eventWriter::close);
            }
        }
    }

    private void postprocessDescriptor(InputStream inputStream, ZipOutputStream out) throws IOException {
        IOUtils.copy((InputStream)inputStream, (OutputStream)out);
        String cmacFlag = "\ncmac=" + this.pluginVersionManager.getPluginVersion() + "\n";
        out.write(cmacFlag.getBytes(StandardCharsets.ISO_8859_1));
    }

    private static final class ProcessingContext {
        final XMLEvent event;
        final XMLEventWriter writer;
        final Map<String, MigrationUser> usernamesToUsers;

        ProcessingContext(XMLEvent event, XMLEventWriter writer, Map<String, MigrationUser> users) {
            this.event = event;
            this.writer = writer;
            this.usernamesToUsers = users;
        }
    }

    private static interface EventProcessor
    extends CheckedFunction<ProcessingContext, EventProcessor> {
    }
}

