/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.space;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.SpaceConflict;
import com.atlassian.migration.agent.service.check.space.SpaceConflictContext;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.impl.MigrationPlatformService;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

@Singleton
public class SpaceConflictChecker
implements Checker<SpaceConflictContext> {
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceConflictChecker.class);
    private static final int ERROR_CODE = 100;
    private static final int CLOUD_ERROR_CODE = 200;
    private static final String VIOLATIONS_KEY = "violations";
    private final MigrationPlatformService migrationPlatformService;
    private final CloudSiteService cloudSiteService;

    @Inject
    SpaceConflictChecker(MigrationPlatformService migrationPlatformService, CloudSiteService cloudSiteService) {
        this.migrationPlatformService = migrationPlatformService;
        this.cloudSiteService = cloudSiteService;
    }

    public CheckResult check(SpaceConflictContext ctx) {
        if (CollectionUtils.isEmpty(ctx.spaceKeys)) {
            return new CheckResult(true);
        }
        Optional<CloudSite> cloudSite = this.cloudSiteService.getByCloudId(ctx.cloudId);
        if (!cloudSite.isPresent()) {
            log.error("CloudSite not found for cloudId {}.", (Object)ctx.cloudId);
            return Checker.buildCheckResultWithExecutionError((int)200);
        }
        String containerToken = cloudSite.get().getContainerToken();
        try {
            Set<SpaceConflict> spaceConflicts = this.migrationPlatformService.getSpaceConflicts(containerToken, ctx.spaceKeys);
            return new CheckResult(spaceConflicts.isEmpty(), Collections.singletonMap(VIOLATIONS_KEY, spaceConflicts));
        }
        catch (RuntimeException e) {
            log.error("Error executing space keys conflict check.", (Throwable)e);
            return Checker.buildCheckResultWithExecutionError((int)100);
        }
    }

    static Set<SpaceConflict> retrieveConflictingSpaces(Map<String, Object> details) {
        return details.getOrDefault(VIOLATIONS_KEY, Collections.emptySet());
    }
}

