/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.migration.agent.entity.CheckExecutionStatus;
import com.atlassian.migration.agent.entity.CheckResultEntity;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.check.CheckResultFileManager;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.store.impl.CheckResultStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Singleton
@ParametersAreNonnullByDefault
public class CheckResultsService {
    private static final Logger log = ContextLoggerFactory.getLogger(CheckResultsService.class);
    private final CheckResultStore checkResultStore;
    private final CheckResultFileManager checkResultFileManager;
    private final PluginTransactionTemplate ptx;

    @Inject
    CheckResultsService(CheckResultStore checkResultStore, CheckResultFileManager checkResultFileManager, PluginTransactionTemplate ptx) {
        this.checkResultStore = checkResultStore;
        this.checkResultFileManager = checkResultFileManager;
        this.ptx = ptx;
    }

    public Optional<CheckResultEntity> getByExecutionIdAndCheckType(String executionId, CheckType checkType) {
        return this.ptx.read(() -> this.checkResultStore.getByExecutionIdAndCheckType(executionId, checkType));
    }

    public List<CheckResultEntity> getByExecutionId(String executionId) {
        return this.ptx.read(() -> this.checkResultStore.getByExecutionId(executionId));
    }

    public CheckResultEntity getOrCreate(String executionId, CheckType checkType) {
        return this.ptx.write(() -> this.checkResultStore.getByExecutionIdAndCheckType(executionId, checkType).orElseGet(() -> {
            CheckResultEntity entity = new CheckResultEntity(executionId, checkType.value());
            this.checkResultStore.create(entity);
            return entity;
        }));
    }

    public void updateStatusToRunning(CheckResultEntity entity) {
        this.ptx.write(() -> {
            entity.setStatus(CheckExecutionStatus.RUNNING);
            this.checkResultStore.update(entity);
        });
    }

    public void saveCheckResult(String executionId, CheckType checkType, CheckResult checkResult) {
        this.ptx.write(() -> {
            String fileId;
            Optional<CheckResultEntity> result = this.checkResultStore.getByExecutionIdAndCheckType(executionId, checkType);
            CheckResultEntity entity = result.orElseThrow(() -> new IllegalArgumentException(String.format("Failed to find checkResult for executionId: %s and checkType: %s", new Object[]{executionId, checkType})));
            entity.setStatus(checkResult.success ? CheckExecutionStatus.SUCCESS : CheckExecutionStatus.ERROR);
            try {
                fileId = this.checkResultFileManager.saveToFile(executionId, checkType, checkResult);
            }
            catch (RuntimeException ex) {
                throw new RuntimeException(String.format("Failed to save check result details to file for executionId = %s and checkType = %s", executionId, checkResult), ex);
            }
            entity.setDetails(fileId);
            entity.setLastExecutionTime(Instant.now());
            this.checkResultStore.update(entity);
        });
    }

    public Optional<CheckResult> getCheckResult(CheckResultEntity entity) {
        if (StringUtils.isNotEmpty((CharSequence)entity.getDetails())) {
            try {
                return Optional.of(this.checkResultFileManager.readFromFile(entity.getDetails()));
            }
            catch (RuntimeException e) {
                log.error("Couldn't retrieve check result", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public int deleteCheckResultsByExecutionId(String executionId) {
        return this.ptx.write(() -> this.checkResultStore.deleteCheckResultsByExecutionId(executionId));
    }

    public void bindCheckIdToPlanId(String checkExecutionId, String planId) {
        this.ptx.write(() -> this.checkResultStore.updateExecutionId(checkExecutionId, planId));
    }

    public void cleanStaleChecks() {
        this.ptx.write(() -> this.checkResultStore.batchUpdateStatus(CheckExecutionStatus.RUNNING, Instant.now().minus(Duration.ofHours(1L)), CheckExecutionStatus.ERROR));
    }
}

