/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.cmpt.analytics.events.GenericScreenEvent;
import com.atlassian.cmpt.analytics.events.GenericTrackEvent;
import com.atlassian.cmpt.analytics.events.GenericUiEvent;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.cmpt.check.email.EmailDuplicate;
import com.atlassian.confluence.cluster.ClusterInformation;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.confluence.status.service.systeminfo.DatabaseInfo;
import com.atlassian.confluence.status.service.systeminfo.UsageInfo;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.migration.agent.dto.ConfluenceSpaceTaskDto;
import com.atlassian.migration.agent.dto.MigrateUsersTaskDto;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.dto.ProgressDto;
import com.atlassian.migration.agent.dto.analytics.ScreenAnalyticsEventDto;
import com.atlassian.migration.agent.dto.analytics.TrackAnalyticsEventDto;
import com.atlassian.migration.agent.dto.analytics.UIAnalyticsEventDto;
import com.atlassian.migration.agent.model.stats.ContentSummary;
import com.atlassian.migration.agent.model.stats.InstanceStats;
import com.atlassian.migration.agent.model.stats.ServerStats;
import com.atlassian.migration.agent.model.stats.SpaceStats;
import com.atlassian.migration.agent.model.stats.UsersGroupsStats;
import com.atlassian.migration.agent.service.SpaceConflict;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.impl.MigrationTimeEstimationUtils;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;

@Singleton
public class AnalyticsEventBuilder {
    private static final EnumSet<DirectoryType> LDAP_DIRECTORY_TYPES = EnumSet.of(DirectoryType.CONNECTOR, DirectoryType.DELEGATING, DirectoryType.CUSTOM);
    private static final String STARTED = "started";
    private static final String STOPPED = "stopped";
    private final SENSupplier senSupplier;
    private final Supplier<Instant> instantSupplier;
    private final StatisticsService statisticsService;
    private final SystemInformationService systemInformationService;
    private final PluginMetadataManager pluginMetadataManager;
    private final CrowdDirectoryService crowdDirectoryService;
    private final SpaceManager spaceManager;
    private final PluginVersionManager pluginVersionManager;
    private final ClusterManager clusterManager;

    @Inject
    public AnalyticsEventBuilder(SENSupplier senSupplier, StatisticsService statisticsService, SystemInformationService systemInformationService, PluginMetadataManager pluginMetadataManager, CrowdDirectoryService crowdDirectoryService, SpaceManager spaceManager, PluginVersionManager pluginVersionManager, ClusterManager clusterManager) {
        this(senSupplier, Instant::now, statisticsService, systemInformationService, pluginMetadataManager, crowdDirectoryService, spaceManager, pluginVersionManager, clusterManager);
    }

    @VisibleForTesting
    AnalyticsEventBuilder(SENSupplier senSupplier, Supplier<Instant> instantSupplier, StatisticsService statisticsService, SystemInformationService systemInformationService, PluginMetadataManager pluginMetadataManager, CrowdDirectoryService crowdDirectoryService, SpaceManager spaceManager, PluginVersionManager pluginVersionManager, ClusterManager clusterManager) {
        this.senSupplier = senSupplier;
        this.instantSupplier = instantSupplier;
        this.statisticsService = statisticsService;
        this.systemInformationService = systemInformationService;
        this.pluginMetadataManager = pluginMetadataManager;
        this.crowdDirectoryService = crowdDirectoryService;
        this.spaceManager = spaceManager;
        this.pluginVersionManager = pluginVersionManager;
        this.clusterManager = clusterManager;
    }

    public EventDto buildUIAnalyticsEvent(UIAnalyticsEventDto eventDto, ConfluenceUser confluenceUser) {
        return ((GenericUiEvent.Builder)((GenericUiEvent.Builder)((GenericUiEvent.Builder)((GenericUiEvent.Builder)((GenericUiEvent.Builder)((GenericUiEvent.Builder)((GenericUiEvent.Builder)new GenericUiEvent.Builder(eventDto.getTimestamp()).email(confluenceUser.getEmail())).sen(this.senSupplier.get())).source(eventDto.getSource())).contextContainer(eventDto.getContainerType(), eventDto.getContainerId())).actionSubject(eventDto.getActionSubject(), eventDto.getActionSubjectId())).action(eventDto.getAction())).withAttributes(eventDto.getAttributes())).build();
    }

    public EventDto buildScreenAnalyticsEvent(ScreenAnalyticsEventDto eventDto, ConfluenceUser confluenceUser) {
        return ((GenericScreenEvent.Builder)((GenericScreenEvent.Builder)((GenericScreenEvent.Builder)((GenericScreenEvent.Builder)new GenericScreenEvent.Builder(eventDto.getTimestamp()).name(eventDto.getName())).sen(this.senSupplier.get())).email(confluenceUser.getEmail())).withAttributes(eventDto.getAttributes())).build();
    }

    public EventDto buildCompletedInstanceAnalysisAnalyticsEvent(ServerStats serverStats, ConfluenceUser confluenceUser) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        DatabaseInfo databaseInfo = this.systemInformationService.getDatabaseInfo();
        attributes.put((Object)"database", (Object)ImmutableMap.of((Object)"type", (Object)databaseInfo.getName(), (Object)"version", (Object)databaseInfo.getVersion()));
        ConfluenceInfo confluenceInfo = this.systemInformationService.getConfluenceInfo();
        attributes.put((Object)"apps", (Object)confluenceInfo.getEnabledPlugins().stream().filter(arg_0 -> ((PluginMetadataManager)this.pluginMetadataManager).isUserInstalled(arg_0)).map(Plugin::getKey).collect(Collectors.toCollection(LinkedList::new)));
        List directories = this.crowdDirectoryService.findAllDirectories();
        boolean ldap = directories.stream().filter(Directory::isActive).map(Directory::getType).anyMatch(LDAP_DIRECTORY_TYPES::contains);
        attributes.put((Object)"LDAP", (Object)ldap);
        attributes.put((Object)"estimatedTime", (Object)Long.toString(serverStats.getTotalSpaceMigrationTime().plus(serverStats.getTotalUserGroupMigrationTime()).plus(MigrationTimeEstimationUtils.getBaseMigrationTime()).getSeconds()));
        InstanceStats instanceStats = serverStats.getInstanceStats();
        attributes.put((Object)"version", (Object)instanceStats.getVersion());
        attributes.put((Object)"numberOfSpaces", (Object)Long.toString(instanceStats.getNumberOfSpaces()));
        attributes.put((Object)"numberOfUsers", (Object)Long.toString(instanceStats.getNumberOfUsers()));
        attributes.put((Object)"numberOfGroups", (Object)Long.toString(instanceStats.getNumberOfGroups()));
        ContentSummary contentSummary = serverStats.getContentSummary();
        attributes.put((Object)"totalAttachmentsSize", (Object)Long.toString(contentSummary.getAttachments().getTotalSize()));
        attributes.put((Object)"numberOfPages", (Object)Long.toString(contentSummary.getNumberOfPages()));
        attributes.put((Object)"numberOfBlogs", (Object)Long.toString(contentSummary.getNumberOfBlogs()));
        ClusterInformation clusterInformation = this.clusterManager.getClusterInformation();
        attributes.put((Object)"clustered", (Object)this.clusterManager.isClustered());
        attributes.put((Object)"numberOfNodes", (Object)Integer.toString(clusterInformation.getMemberCount()));
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).email(confluenceUser.getEmail())).sen(this.senSupplier.get())).action("completed")).actionSubject("instanceAnalysis")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildCompletedPlanAnalyticsEvent(PlanDto planDto) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"status", (Object)planDto.getProgress().getStatus());
        attributes.put((Object)"numberOfObjects", (Object)Long.toString(planDto.getTasks().size()));
        UsageInfo usageInfo = this.systemInformationService.getUsageInfo();
        Duration userGroupMigrationTime = MigrationTimeEstimationUtils.estimateTotalUserGroupMigrationTime(usageInfo.getLocalUsers(), usageInfo.getLocalGroups());
        List<String> spaceKeys = this.getSpaceKeysByPlan(planDto);
        long spaceMigrationTime = this.calculateSpaceMigrationTime(spaceKeys);
        attributes.put((Object)"estimatedTime", (Object)Long.toString(userGroupMigrationTime.plus(MigrationTimeEstimationUtils.getBaseMigrationTime()).getSeconds() + spaceMigrationTime));
        long actualTime = Duration.between(planDto.getProgress().getStartTime(), planDto.getProgress().getEndTime()).getSeconds();
        attributes.put((Object)"actualTime", (Object)Long.toString(actualTime));
        attributes.put((Object)"startTime", (Object)planDto.getProgress().getStartTime());
        attributes.put((Object)"stopTime", (Object)planDto.getProgress().getEndTime());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("completed")).sen(this.senSupplier.get())).actionSubject("plan", planDto.getId())).source("monitorScreen")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildUpdatedPlanStatusAnalyticEvent(PlanDto planDto, ProgressDto.Status fromStatus) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"oldStatus", (Object)fromStatus.name());
        attributes.put((Object)"newStatus", (Object)planDto.getProgress().getStatus().name());
        List<String> spaceKeys = this.getSpaceKeysByPlan(planDto);
        Collection<SpaceStats> spaceStats = this.statisticsService.loadSpaceStatistics(spaceKeys);
        long totalAttachmentsSize = spaceStats.stream().mapToLong(spaceStat -> spaceStat.getSummary().getAttachments().getTotalSize()).sum();
        attributes.put((Object)"totalAttachmentsSize", (Object)totalAttachmentsSize);
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("updated")).sen(this.senSupplier.get())).actionSubject("planStatus", planDto.getId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildStartPlanAnalyticsEvent(PlanDto planDto) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"status", (Object)"RUNNING");
        attributes.put((Object)"numberOfObjects", (Object)Long.toString(planDto.getTasks().size()));
        attributes.put((Object)"startTime", (Object)planDto.getProgress().getStartTime());
        UsageInfo usageInfo = this.systemInformationService.getUsageInfo();
        Duration userGroupMigrationTime = MigrationTimeEstimationUtils.estimateTotalUserGroupMigrationTime(usageInfo.getLocalUsers(), usageInfo.getLocalGroups());
        List<String> spaceKeys = this.getSpaceKeysByPlan(planDto);
        long spaceMigrationTime = this.calculateSpaceMigrationTime(spaceKeys);
        attributes.put((Object)"estimatedTime", (Object)Long.toString(userGroupMigrationTime.getSeconds() + spaceMigrationTime));
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(STARTED)).sen(this.senSupplier.get())).actionSubject("plan", planDto.getId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildUpdatedTaskStatusAnalyticEvent(String planId, String taskId, String type, ProgressDto.Status fromStatus, ProgressDto.Status toStatus, String spaceKey) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"oldStatus", (Object)fromStatus.name());
        attributes.put((Object)"newStatus", (Object)toStatus);
        attributes.put((Object)"type", (Object)type);
        attributes.put((Object)"planId", (Object)planId);
        if (StringUtils.isNotEmpty((String)spaceKey)) {
            Space space = this.spaceManager.getSpace(spaceKey);
            attributes.put((Object)"spaceId", (Object)Long.toString(space.getId()));
            SpaceStats spaceStats = this.statisticsService.loadSpaceStatistics(spaceKey);
            attributes.put((Object)"totalAttachmentsSize", (Object)spaceStats.getSummary().getAttachments().getTotalSize());
        }
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("updated")).sen(this.senSupplier.get())).actionSubject("objectStatus", taskId)).withAttributes((Map)attributes.build())).build();
    }

    public List<EventDto> buildCreatePlanAndTasksAnalyticsEvents(PlanDto planDto, ConfluenceUser confluenceUser) {
        long now = this.instantSupplier.get().toEpochMilli();
        LongAdder numberOfSpaces = new LongAdder();
        LongAdder estimatedTime = new LongAdder();
        ArrayList<EventDto> analyticsEventModels = new ArrayList<EventDto>();
        String planId = planDto.getId();
        planDto.getTasks().forEach(task -> {
            if (task instanceof ConfluenceSpaceTaskDto) {
                ConfluenceSpaceTaskDto confluenceSpaceTaskDto = (ConfluenceSpaceTaskDto)task;
                SpaceStats spaceStats = this.statisticsService.loadSpaceStatistics(confluenceSpaceTaskDto.getSpace());
                numberOfSpaces.increment();
                long thisEstimatedTime = MigrationTimeEstimationUtils.estimateSpaceMigrationTime(spaceStats.getSummary()).getSeconds();
                estimatedTime.add(thisEstimatedTime);
                analyticsEventModels.add(this.buildAddedSpaceAnalyticsEvent(now, planId, confluenceSpaceTaskDto, thisEstimatedTime, spaceStats, confluenceUser));
            } else if (task instanceof MigrateUsersTaskDto) {
                MigrateUsersTaskDto migrateUsersTaskDto = (MigrateUsersTaskDto)task;
                UsersGroupsStats usersStats = this.statisticsService.getUsersGroupsStatistics();
                estimatedTime.add(usersStats.getTotalMigrationTime().getSeconds());
                analyticsEventModels.add(this.buildAddedUserGroupsAnalyticsEvent(now, planId, migrateUsersTaskDto, usersStats.getTotalMigrationTime().getSeconds(), usersStats, confluenceUser));
            }
        });
        analyticsEventModels.add(0, this.buildCreatedPlanAnalyticsEvent(now, planDto, numberOfSpaces.longValue(), estimatedTime.longValue(), confluenceUser));
        return analyticsEventModels;
    }

    EventDto buildCreatedPlanAnalyticsEvent(long now, PlanDto planDto, long numberOfSpaces, long estimatedTime, ConfluenceUser confluenceUser) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"status", (Object)planDto.getProgress().getStatus());
        attributes.put((Object)"numberOfSpaces", (Object)Long.toString(numberOfSpaces));
        attributes.put((Object)"estimatedTime", (Object)Long.toString(estimatedTime));
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(now).action("created")).sen(this.senSupplier.get())).email(confluenceUser.getEmail())).source("reviewScreen")).actionSubject("plan", planDto.getId())).withAttributes((Map)attributes.build())).build();
    }

    EventDto buildAddedSpaceAnalyticsEvent(long now, String planId, ConfluenceSpaceTaskDto confluenceSpaceTaskDto, long estimatedTime, SpaceStats spaceStats, ConfluenceUser confluenceUser) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"planId", (Object)planId);
        attributes.put((Object)"status", (Object)confluenceSpaceTaskDto.getProgress().getStatus());
        attributes.put((Object)"type", (Object)"confluence-space");
        attributes.put((Object)"estimatedTime", (Object)Long.toString(estimatedTime));
        attributes.put((Object)"numberOfPages", (Object)Long.toString(spaceStats.getSummary().getNumberOfPages()));
        attributes.put((Object)"numberOfBlogs", (Object)Long.toString(spaceStats.getSummary().getNumberOfBlogs()));
        attributes.put((Object)"numberOfDrafts", (Object)Long.toString(spaceStats.getSummary().getNumberOfDrafts()));
        attributes.put((Object)"numberOfAttachments", (Object)Long.toString(spaceStats.getSummary().getNumberOfAttachments()));
        Space space = this.spaceManager.getSpace(confluenceSpaceTaskDto.getSpace());
        attributes.put((Object)"spaceId", (Object)Long.toString(space.getId()));
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(now).action("added")).sen(this.senSupplier.get())).email(confluenceUser.getEmail())).source("reviewScreen")).actionSubject("object", confluenceSpaceTaskDto.getId())).withAttributes((Map)attributes.build())).build();
    }

    EventDto buildAddedUserGroupsAnalyticsEvent(long now, String planId, MigrateUsersTaskDto migrateUsersTaskDto, long estimatedTime, UsersGroupsStats usersStats, ConfluenceUser confluenceUser) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"planId", (Object)planId);
        attributes.put((Object)"status", (Object)migrateUsersTaskDto.getProgress().getStatus());
        attributes.put((Object)"type", (Object)"users-and-groups");
        attributes.put((Object)"estimatedTime", (Object)Long.toString(estimatedTime));
        attributes.put((Object)"numberOfUsers", (Object)Long.toString(usersStats.getNumberOfUsers()));
        attributes.put((Object)"numberOfGroups", (Object)Long.toString(usersStats.getNumberOfGroups()));
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(now).action("added")).sen(this.senSupplier.get())).email(confluenceUser.getEmail())).source("reviewScreen")).actionSubject("object", migrateUsersTaskDto.getId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildTrackAnalyticsEvent(TrackAnalyticsEventDto eventDto, PlanDto planDto, ConfluenceUser confluenceUser) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        String action = eventDto.getAction();
        if (STOPPED.equals(action)) {
            attributes.put((Object)"status", (Object)planDto.getProgress().getStatus());
            attributes.put((Object)"stopTime", (Object)planDto.getProgress().getEndTime());
        }
        return ((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)((GenericTrackEvent.Builder)new GenericTrackEvent.Builder(eventDto.getTimestamp()).action(eventDto.getAction())).sen(this.senSupplier.get())).email(confluenceUser.getEmail())).source(eventDto.getSource())).actionSubject(eventDto.getActionSubject(), eventDto.getActionSubjectId())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightDuplicateEmails(boolean success, List<EmailDuplicate> duplicateEmails, long totalTime) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        LongAdder numberOfEmails = new LongAdder();
        LongAdder numberOfUsers = new LongAdder();
        duplicateEmails.forEach(duplicateEmail -> {
            numberOfEmails.increment();
            numberOfUsers.add(duplicateEmail.ids.size());
        });
        attributes.put((Object)"numberOfSharedEmails", (Object)Long.toString(numberOfEmails.longValue()));
        attributes.put((Object)"numberOfUsers", (Object)Long.toString(numberOfUsers.longValue()));
        this.addCommonAttributesInPreflightCheck(success, totalTime, (ImmutableMap.Builder<String, Object>)attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("sharedEmailsCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightInvalidEmails(boolean success, List<EmailData> invalidEmails, long totalTime) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"numberOfInvalidEmails", (Object)Long.toString(invalidEmails.size()));
        this.addCommonAttributesInPreflightCheck(success, totalTime, (ImmutableMap.Builder<String, Object>)attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("invalidEmailsCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightGroupNamesConflict(boolean success, List<String> groups, long totalTime) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"numberOfGroups", (Object)Long.toString(groups.size()));
        this.addCommonAttributesInPreflightCheck(success, totalTime, (ImmutableMap.Builder<String, Object>)attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("cloudExistantGroupsCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightSpaceKeysConflict(boolean success, Set<SpaceConflict> conflicts, long totalTime) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"numberOfSpaces", (Object)Long.toString(conflicts.size()));
        this.addCommonAttributesInPreflightCheck(success, totalTime, (ImmutableMap.Builder<String, Object>)attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("spaceConflictCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightAppOutdated(boolean success, long totalTime) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        this.addCommonAttributesInPreflightCheck(success, totalTime, (ImmutableMap.Builder<String, Object>)attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("migrationAssistantOutdatedCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightCloudFreeUsersCheck(boolean success, Status status, long totalTime) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"status", (Object)status.value());
        this.addCommonAttributesInPreflightCheck(success, totalTime, (ImmutableMap.Builder<String, Object>)attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("cloudFreeUsersConflictCheck")).withAttributes((Map)attributes.build())).build();
    }

    private void addCommonAttributesInPreflightCheck(boolean success, long totalTime, ImmutableMap.Builder<String, Object> attributes) {
        attributes.put((Object)"success", (Object)success);
        attributes.put((Object)"totalTime", (Object)String.format(Locale.US, "%.1f", (double)totalTime / 1000.0));
    }

    public EventDto buildPreflightFailed(String actionSubject, int executionErrorCode) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"executionErrorCode", (Object)executionErrorCode);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("failed")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject(actionSubject)).withAttributes((Map)attributes.build())).build();
    }

    private List<String> getSpaceKeysByPlan(PlanDto planDto) {
        return planDto.getTasks().stream().filter(ConfluenceSpaceTaskDto.class::isInstance).map(taskDto -> ((ConfluenceSpaceTaskDto)taskDto).getSpace()).collect(Collectors.toList());
    }

    private long calculateSpaceMigrationTime(List<String> spaceKeys) {
        Collection<SpaceStats> spaceStats = this.statisticsService.loadSpaceStatistics(spaceKeys);
        List<ContentSummary> spaceSummaries = spaceStats.stream().map(SpaceStats::getSummary).collect(Collectors.toList());
        return MigrationTimeEstimationUtils.estimateTotalSpaceMigrationTime(spaceSummaries).getSeconds();
    }
}

