/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.media.client.util;

import com.atlassian.fugue.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class UrnHelper {
    private static final String SEPARATOR = ":";
    private static final List<String> OPERATIONS_CREATE = Collections.singletonList(Operation.CREATE.getKey());
    private static final List<String> OPERATIONS_READ = Collections.singletonList(Operation.READ.getKey());
    private static final List<String> OPERATIONS_UPDATE = Collections.singletonList(Operation.UPDATE.getKey());
    private static final List<String> OPERATIONS_DELETE = Collections.singletonList(Operation.DELETE.getKey());

    public static Pair<String, List<String>> toCreateFile() {
        return Pair.pair((Object)ResourceType.FILE.getPrefix(), OPERATIONS_CREATE);
    }

    public static Pair<String, List<String>> toReadFile(String fileId) {
        return Pair.pair((Object)(ResourceType.FILE.getPrefix() + SEPARATOR + Objects.requireNonNull(fileId)), OPERATIONS_READ);
    }

    public static Pair<String, List<String>> toDeleteFile(String fileId) {
        return Pair.pair((Object)(ResourceType.FILE.getPrefix() + SEPARATOR + Objects.requireNonNull(fileId)), OPERATIONS_DELETE);
    }

    public static Pair<String, List<String>> toReadAnyChunk() {
        return Pair.pair((Object)(ResourceType.CHUNK.getPrefix() + SEPARATOR + "*"), OPERATIONS_READ);
    }

    public static Pair<String, List<String>> toCreateAnyChunk() {
        return Pair.pair((Object)(ResourceType.CHUNK.getPrefix() + SEPARATOR + "*"), OPERATIONS_CREATE);
    }

    public static Pair<String, List<String>> toCreateUploads() {
        return Pair.pair((Object)ResourceType.UPLOAD.getPrefix(), OPERATIONS_CREATE);
    }

    public static Pair<String, List<String>> toReadAnUpload(String uploadId) {
        return Pair.pair((Object)(ResourceType.UPLOAD.getPrefix() + SEPARATOR + Objects.requireNonNull(uploadId)), OPERATIONS_READ);
    }

    public static Pair<String, List<String>> toUpdateAnUpload(String uploadId) {
        return Pair.pair((Object)(ResourceType.UPLOAD.getPrefix() + SEPARATOR + Objects.requireNonNull(uploadId)), OPERATIONS_UPDATE);
    }

    private static enum Operation {
        CREATE,
        READ,
        UPDATE,
        DELETE;


        public String getKey() {
            return this.name().toLowerCase();
        }
    }

    private static enum ResourceType {
        FILE("urn:filestore:file"),
        CHUNK("urn:filestore:chunk"),
        GRANT("urn:filestore:grant"),
        UPLOAD("urn:filestore:upload");

        private final String prefix;

        private ResourceType(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

