/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins;

import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.plugin.MojoExecutionException;

public class PathParserUtil {
    static Set toFiles(String[] paths) throws MojoExecutionException {
        HashSet resources = new HashSet();
        for (int i = 0; i < paths.length; ++i) {
            Set nextSet = PathParserUtil.toFiles(paths[i]);
            if (nextSet == null) continue;
            resources.addAll(nextSet);
        }
        return resources;
    }

    static Set toFiles(String pathStr) throws MojoExecutionException {
        if (pathStr.length() == 0) {
            return null;
        }
        ResourceDescriptor descr = new ResourceDescriptor(pathStr);
        HashSet<File> resources = new HashSet<File>();
        File resource = new File(descr.path);
        if (resource.exists()) {
            if (descr.wildcard != null) {
                if (resource.isDirectory()) {
                    PathParserUtil.getMatchingChildren(resource, descr.wildcard, resources);
                }
            } else {
                resources.add(resource);
            }
        }
        return resources;
    }

    static void getMatchingChildren(File resource, String wildcard, Set resources) {
        WildcardFileFilter filter = new WildcardFileFilter(wildcard);
        File[] children = resource.listFiles((FileFilter)filter);
        for (int i = 0; i < children.length; ++i) {
            resources.add(children[i]);
        }
    }

    static int findFirstGlobCharPosition(String path) {
        char[] array = path.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != '?' && array[i] != '*') continue;
            return i;
        }
        return -1;
    }

    static class ResourceDescriptor {
        final String path;
        final String wildcard;

        public ResourceDescriptor(String path) throws MojoExecutionException {
            int pos = PathParserUtil.findFirstGlobCharPosition(path);
            if (pos != -1) {
                int dirEndPos = path.replace('\\', '/').lastIndexOf(47);
                if (dirEndPos >= pos) {
                    throw new MojoExecutionException("Invalid path - '" + path + "'. Wildcards must not contain a path separator '/' or '\\'.");
                }
                if (dirEndPos == -1) {
                    this.path = "";
                    this.wildcard = path;
                } else {
                    this.path = path.substring(0, dirEndPos + 1);
                    this.wildcard = path.substring(dirEndPos + 1);
                }
            } else {
                this.path = path;
                this.wildcard = null;
            }
        }
    }
}

