/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class ConfigFileUtils {
    public static void replace(List<File> files, List<Replacement> replacements, boolean inverted, Log log) throws MojoExecutionException {
        for (File file : files) {
            ConfigFileUtils.replace(file, replacements, inverted, log);
        }
    }

    public static void replace(File cfgFile, List<Replacement> replacements, boolean inverted, Log log) throws MojoExecutionException {
        if (!cfgFile.exists()) {
            return;
        }
        try {
            String config = FileUtils.readFileToString((File)cfgFile);
            if (!inverted) {
                for (Replacement replacement : replacements) {
                    if (!replacement.applyWhenUnzipping()) continue;
                    config = config.replace(replacement.getKey(), replacement.getValue());
                }
            } else {
                for (Replacement replacement : replacements) {
                    if (!replacement.isReversible()) continue;
                    config = config.replace(replacement.getValue(), replacement.getKey());
                }
            }
            FileUtils.writeStringToFile((File)cfgFile, (String)config);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to replace " + cfgFile, (Exception)ex);
        }
    }

    public static void replaceAll(File cfgFile, String pattern, String replacement) throws MojoExecutionException {
        if (!cfgFile.exists()) {
            return;
        }
        try {
            String config = FileUtils.readFileToString((File)cfgFile);
            config = config.replaceAll(pattern, replacement);
            FileUtils.writeStringToFile((File)cfgFile, (String)config);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to replace " + cfgFile, (Exception)ex);
        }
    }

    public static void setProperties(File propertiesFile, Map<String, String> newProperties) throws MojoExecutionException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(propertiesFile);
            Properties props = new Properties();
            props.load(in);
            ((InputStream)in).close();
            in = null;
            for (Map.Entry<String, String> e : newProperties.entrySet()) {
                props.setProperty(e.getKey(), e.getValue());
            }
            out = new FileOutputStream(propertiesFile);
            props.store(out, "Processed by AMPS");
            ((OutputStream)out).close();
            out = null;
        }
        catch (IOException ioe) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
        }
    }

    public static class Replacement {
        String key;
        String value;
        boolean applyWhenUnzipping = true;
        boolean reversible = true;

        public Replacement(String key, String value) {
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key must not be null");
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value must not be null");
            this.key = key;
            this.value = value;
        }

        public Replacement(String key, String value, boolean reversible) {
            this(key, value);
            this.reversible = reversible;
        }

        public Replacement(String key, String value, boolean applyWhenUnzipping, boolean applyWhenZipping) {
            this(key, value);
            this.applyWhenUnzipping = applyWhenUnzipping;
            this.reversible = applyWhenZipping;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isReversible() {
            return this.reversible;
        }

        public boolean applyWhenUnzipping() {
            return this.applyWhenUnzipping;
        }

        public String toString() {
            if (this.reversible) {
                return this.key + " <-> " + this.value;
            }
            return this.key + " -> " + this.value;
        }
    }
}

