/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.studio;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.JiraProductHandler;
import com.atlassian.maven.plugins.amps.product.studio.StudioComponentProductHandler;
import com.atlassian.maven.plugins.amps.product.studio.StudioProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;

public class StudioJiraProductHandler
extends JiraProductHandler
implements StudioComponentProductHandler {
    public StudioJiraProductHandler(MavenContext context, MavenGoals goals) {
        super(context, goals);
    }

    @Override
    public String getId() {
        return "studio-jira";
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.studio", "studio-jira", "RELEASE");
    }

    @Override
    protected void customiseInstance(Product ctx, File homeDir, File explodedWarDir) throws MojoExecutionException {
        ArrayList configFiles = Lists.newArrayList();
        configFiles.add(new File(explodedWarDir, "WEB-INF/classes/entityengine.xml"));
        configFiles.add(new File(explodedWarDir, "WEB-INF/web.xml"));
        ArrayList replacements = Lists.newArrayList();
        replacements.add(new ConfigFileUtils.Replacement("field-type-name=\"postgres72\"", "field-type-name=\"hsql\"", false));
        replacements.add(new ConfigFileUtils.Replacement("schema-name=\"public\"", "schema-name=\"PUBLIC\"", false));
        replacements.add(new ConfigFileUtils.Replacement("%JIRA-HOME%", homeDir.getAbsolutePath()));
        ConfigFileUtils.replace(configFiles, (List<ConfigFileUtils.Replacement>)replacements, false, this.log);
        File importsDir = new File(homeDir, "import");
        if (importsDir.exists()) {
            configFiles = Lists.newArrayList((Object[])importsDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            }));
            replacements = Lists.newArrayList((Object[])new ConfigFileUtils.Replacement[]{new ConfigFileUtils.Replacement("%JIRA-HOME%", homeDir.getAbsolutePath())});
            ConfigFileUtils.replace(configFiles, (List<ConfigFileUtils.Replacement>)replacements, false, this.log);
        }
        StudioProductHandler.addProductHandlerOverrides(this.log, ctx, homeDir, explodedWarDir);
        if (ctx.getJvmArgs() == null) {
            ctx.setJvmArgs("-Xms256m -Xmx768m -XX:MaxPermSize=512m");
        } else {
            ctx.setJvmArgs(ctx.getJvmArgs() + " -Xms256m -Xmx768m -XX:MaxPermSize=512m");
        }
    }

    @Override
    public Map<String, String> getSystemProperties(Product product) {
        HashMap<String, String> properties = new HashMap<String, String>(super.getSystemProperties(product));
        properties.putAll(product.getStudioProperties().getSystemProperties());
        return properties;
    }
}

