/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.studio;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.ConfluenceProductHandler;
import com.atlassian.maven.plugins.amps.product.studio.StudioComponentProductHandler;
import com.atlassian.maven.plugins.amps.product.studio.StudioProductHandler;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;

public class StudioConfluenceProductHandler
extends ConfluenceProductHandler
implements StudioComponentProductHandler {
    public StudioConfluenceProductHandler(MavenContext context, MavenGoals goals) {
        super(context, goals);
    }

    @Override
    public String getId() {
        return "studio-confluence";
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.studio", "studio-confluence", "RELEASE");
    }

    @Override
    public Map<String, String> getSystemProperties(Product product) {
        HashMap<String, String> systemProperties = new HashMap<String, String>(super.getSystemProperties(product));
        String dburl = System.getProperty("amps.datasource.url", String.format("jdbc:hsqldb:%s/database/confluencedb;hsqldb.tx=MVCC", StudioProductHandler.fixWindowsSlashes(this.getHomeDirectory(product).getAbsolutePath())));
        String driverClass = System.getProperty("amps.datasource.driver", "org.hsqldb.jdbcDriver");
        String username = System.getProperty("amps.datasource.username", "sa");
        String password = System.getProperty("amps.datasource.password", "");
        String datasourceTypeClass = "javax.sql.DataSource";
        String datasource = String.format("cargo.datasource.url=%s", dburl);
        String driver = String.format("cargo.datasource.driver=%s", driverClass);
        String datasourceUsername = String.format("cargo.datasource.username=%s", username);
        String datasourcePassword = String.format("cargo.datasource.password=%s", password);
        String datasourceType = "cargo.datasource.type=javax.sql.DataSource";
        String jndi = "cargo.datasource.jndi=jdbc/DefaultDS";
        systemProperties.put("cargo.datasource.datasource", String.format("%s|%s|%s|%s|%s|%s", datasource, driver, datasourceUsername, datasourcePassword, "cargo.datasource.type=javax.sql.DataSource", "cargo.datasource.jndi=jdbc/DefaultDS"));
        systemProperties.putAll(product.getStudioProperties().getSystemProperties());
        return systemProperties;
    }

    @Override
    public List<ProductArtifact> getExtraContainerDependencies() {
        return Arrays.asList(new ProductArtifact("org.hsqldb", "hsqldb", "2.2.4"), new ProductArtifact("jta", "jta", "1.0.1"));
    }

    @Override
    public void processHomeDirectory(Product ctx, File homeDir) throws MojoExecutionException {
        super.processHomeDirectory(ctx, homeDir);
        StudioProductHandler.processProductsHomeDirectory(this.log, ctx, homeDir);
    }

    @Override
    protected void customiseInstance(Product ctx, File homeDir, File explodedWarDir) throws MojoExecutionException {
        StudioProductHandler.addProductHandlerOverrides(this.log, ctx, homeDir, explodedWarDir);
    }
}

