/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.atlassian.maven.plugins.amps.util.ZipUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public abstract class AmpsProductHandler
implements ProductHandler {
    protected final MavenGoals goals;
    protected final MavenProject project;
    protected final MavenContext context;
    protected final Log log;

    protected AmpsProductHandler(MavenContext context, MavenGoals goals) {
        this.project = context.getProject();
        this.context = context;
        this.goals = goals;
        this.log = context.getLog();
    }

    @Override
    public void createHomeZip(File homeDirectory, File targetZip, Product product) throws MojoExecutionException {
        if (homeDirectory == null || !homeDirectory.exists()) {
            String homePath = "null";
            if (homeDirectory != null) {
                homePath = homeDirectory.getAbsolutePath();
            }
            this.context.getLog().info((CharSequence)("home directory doesn't exist, skipping. [" + homePath + "]"));
            return;
        }
        try {
            File appDir = this.getBaseDirectory(product);
            File tmpDir = new File(appDir, "tmp-resources");
            File homeSnapshot = new File(tmpDir, "generated-home");
            String entryBase = "generated-resources/" + product.getId() + "-home";
            if (homeSnapshot.exists()) {
                FileUtils.deleteDirectory((File)homeSnapshot);
            }
            homeSnapshot.mkdirs();
            FileUtils.copyDirectory((File)homeDirectory, (File)homeSnapshot, (boolean)true);
            this.cleanupProductHomeForZip(product, homeSnapshot);
            ZipUtils.zipDir(targetZip, homeSnapshot, entryBase);
        }
        catch (IOException e) {
            throw new RuntimeException("Error zipping home directory", e);
        }
    }

    @Override
    public void cleanupProductHomeForZip(Product product, File snapshotDir) throws MojoExecutionException, IOException {
        try {
            FileUtils.deleteDirectory((File)new File(snapshotDir, "plugins"));
            FileUtils.deleteDirectory((File)new File(snapshotDir, "bundled-plugins"));
            if (this.getTestResourcesArtifact() != null) {
                String originalHomeZip = this.getTestResourcesArtifact().getArtifactId() + ".zip";
                FileUtils.deleteQuietly((File)new File(snapshotDir, originalHomeZip));
            }
            List<ConfigFileUtils.Replacement> replacements = this.getReplacements(product);
            Collections.sort(replacements, new Comparator<ConfigFileUtils.Replacement>(){

                @Override
                public int compare(ConfigFileUtils.Replacement replacement1, ConfigFileUtils.Replacement replacement2) {
                    int length1 = replacement1.getValue().length();
                    int length2 = replacement2.getValue().length();
                    return length2 - length1;
                }
            });
            List<File> files = this.getConfigFiles(product, snapshotDir);
            ConfigFileUtils.replace(files, replacements, true, this.log);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not delete home/plugins/ and /home/bundled-plugins/", (Exception)ioe);
        }
    }

    protected abstract ProductArtifact getTestResourcesArtifact();

    protected File getProductHomeData(Product ctx) throws MojoExecutionException {
        File productHomeZip = null;
        String dataPath = ctx.getDataPath();
        if (StringUtils.isNotBlank((String)dataPath)) {
            File customHomeZip = new File(dataPath);
            if (customHomeZip.exists()) {
                return customHomeZip;
            }
            throw new MojoExecutionException("Unable to use custom test resources set by <dataPath>. File '" + customHomeZip.getAbsolutePath() + "' does not exist");
        }
        ProductArtifact testResourcesArtifact = this.getTestResourcesArtifact();
        if (productHomeZip == null && testResourcesArtifact != null) {
            ProductArtifact artifact = new ProductArtifact(testResourcesArtifact.getGroupId(), testResourcesArtifact.getArtifactId(), ctx.getDataVersion());
            productHomeZip = this.goals.copyHome(this.getBaseDirectory(ctx), artifact);
        }
        return productHomeZip;
    }

    protected void overrideAndPatchHomeDir(File homeDir, Product ctx) throws MojoExecutionException {
        try {
            File srcDir = new File(this.project.getBasedir(), "src/test/resources/" + ctx.getInstanceId() + "-home");
            if (srcDir.exists() && homeDir.exists()) {
                FileUtils.copyDirectory((File)srcDir, (File)homeDir);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to override files using src/test/resources", (Exception)e);
        }
    }

    @Override
    public List<ConfigFileUtils.Replacement> getReplacements(Product product) {
        ArrayList replacements = Lists.newArrayList();
        String buildDirectory = this.project.getBuild().getDirectory();
        String baseDirectory = this.getBaseDirectory(product).getAbsolutePath();
        String homeDirectory = this.getHomeDirectory(product).getAbsolutePath();
        replacements.add(new ConfigFileUtils.Replacement("%PROJECT_BUILD_DIR%", buildDirectory));
        replacements.add(new ConfigFileUtils.Replacement("%PRODUCT_BASE_DIR%", baseDirectory));
        replacements.add(new ConfigFileUtils.Replacement("%PRODUCT_HOME_DIR%", homeDirectory));
        try {
            replacements.add(new ConfigFileUtils.Replacement("%PROJECT_BUILD_DIR_URL_ENCODED%", URLEncoder.encode(this.propertiesEncode(buildDirectory), "UTF-8")));
            replacements.add(new ConfigFileUtils.Replacement("%PRODUCT_BASE_DIR_URL_ENCODED%", URLEncoder.encode(this.propertiesEncode(baseDirectory), "UTF-8")));
            replacements.add(new ConfigFileUtils.Replacement("%PRODUCT_HOME_DIR_URL_ENCODED%", URLEncoder.encode(this.propertiesEncode(homeDirectory), "UTF-8")));
        }
        catch (UnsupportedEncodingException badJvm) {
            throw new RuntimeException("UTF-8 should be supported on any JVM", badJvm);
        }
        replacements.add(new ConfigFileUtils.Replacement("localhost", product.getServer(), true, false));
        try {
            String localHostName = InetAddress.getLocalHost().getHostName();
            replacements.add(new ConfigFileUtils.Replacement("%LOCAL_HOST_NAME%", localHostName));
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        return replacements;
    }

    protected String propertiesEncode(String decoded) {
        if (decoded == null) {
            return null;
        }
        String replacement1 = decoded.replaceAll(":", "\\:");
        String replacement2 = replacement1.replaceAll("=", "\\=");
        return replacement2;
    }

    @Override
    public List<File> getConfigFiles(Product product, File snapshotDir) {
        return Lists.newArrayList();
    }

    @Override
    public File getBaseDirectory(Product ctx) {
        return ProjectUtils.createDirectory(new File(this.project.getBuild().getDirectory(), ctx.getInstanceId()));
    }

    @Override
    public File getHomeDirectory(Product ctx) {
        return new File(this.getBaseDirectory(ctx), "home");
    }

    @Override
    public File getSnapshotDirectory(Product product) {
        return this.getHomeDirectory(product);
    }

    protected File createHomeDirectory(Product ctx) {
        return ProjectUtils.createDirectory(this.getHomeDirectory(ctx));
    }
}

