/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.TestGroup;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

public abstract class AbstractTestGroupsHandlerMojo
extends AbstractProductHandlerMojo {
    protected static final String NO_TEST_GROUP = "__no_test_group__";
    @MojoParameter
    private List<TestGroup> testGroups = new ArrayList<TestGroup>();

    protected final List<TestGroup> getTestGroups() {
        return this.testGroups;
    }

    protected final List<ProductExecution> getTestGroupProductExecutions(String testGroupId) throws MojoExecutionException {
        ArrayList<ProductExecution> products = new ArrayList<ProductExecution>();
        int dupCounter = 0;
        HashSet<String> uniqueProductIds = new HashSet<String>();
        Map<String, Product> productContexts = this.getProductContexts(this.getMavenGoals());
        for (String productId : this.getTestGroupProductIds(testGroupId)) {
            Product ctx = productContexts.get(productId);
            if (ctx == null) {
                throw new MojoExecutionException("The test group '" + testGroupId + "' refers to a product '" + productId + "' that doesn't have an associated <product> configuration.");
            }
            ProductHandler productHandler = this.createProductHandler(ctx.getId());
            if (uniqueProductIds.contains(productId)) {
                ctx.setInstanceId(productId + "-" + dupCounter++);
            } else {
                uniqueProductIds.add(productId);
            }
            products.add(new ProductExecution(ctx, productHandler));
        }
        return products;
    }

    private List<String> getTestGroupProductIds(String testGroupId) throws MojoExecutionException {
        ArrayList<String> productIds = new ArrayList<String>();
        if (NO_TEST_GROUP.equals(testGroupId)) {
            productIds.add(this.getProductId());
        }
        for (TestGroup group : this.testGroups) {
            if (!group.getId().equals(testGroupId)) continue;
            productIds.addAll(group.getProductIds());
        }
        if (ProductHandlerFactory.getIds().contains(testGroupId) && !productIds.contains(testGroupId)) {
            productIds.add(testGroupId);
        }
        if (productIds.isEmpty()) {
            ArrayList<String> validTestGroups = new ArrayList<String>();
            for (TestGroup group : this.testGroups) {
                validTestGroups.add(group.getId());
            }
            throw new MojoExecutionException("Unknown test group ID: " + testGroupId + " Detected IDs: " + Arrays.toString(validTestGroups.toArray()));
        }
        return productIds;
    }
}

