/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.osgi;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.osgi.PluginDependency;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MojoGoal(value="generate-obr-artifact")
public class GenerateObrArtifactMojo
extends AbstractAmpsMojo {
    @MojoParameter
    private List<PluginDependency> pluginDependencies = new ArrayList<PluginDependency>();
    @MojoComponent(role="org.codehaus.plexus.archiver.Archiver", roleHint="jar")
    private JarArchiver jarArchiver;
    @MojoParameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @MojoParameter(expression="${attach}", defaultValue="true")
    private boolean attach;
    @MojoComponent
    private MavenProjectHelper projectHelper;
    @MojoParameter(defaultValue="${project.build.directory}")
    protected File outputDirectory;
    @MojoParameter(defaultValue="${project.build.finalName}")
    protected String finalName;
    @MojoParameter(expression="${reactorProjects}", readonly=true)
    protected List<MavenProject> reactorProjects;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Build build = this.getMavenContext().getProject().getBuild();
            List<File> deps = this.resolvePluginDependencies();
            File obrDir = this.layoutObr(deps, new File(build.getDirectory(), build.getFinalName() + ".jar"));
            this.generateObrZip(obrDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void generateObrZip(File obrDir) throws MojoExecutionException {
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        File outputFile = new File(this.outputDirectory, this.finalName + ".obr");
        MavenProject mavenProject = this.getMavenContext().getProject();
        try {
            archiver.getArchiver().addDirectory(obrDir, "");
            archiver.setOutputFile(outputFile);
            this.archive.setAddMavenDescriptor(false);
            this.archive.setForced(true);
            archiver.createArchive(mavenProject, this.archive);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating obr archive: " + e.getMessage(), (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error creating obr archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error creating obr archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("Error creating obr archive: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.attach) {
            this.projectHelper.attachArtifact(mavenProject, this.getType(), outputFile);
        } else {
            this.getLog().info((CharSequence)("NOT adding " + this.getType() + " to attached artifacts list, so it won't be installed or deployed."));
        }
    }

    private File layoutObr(List<File> deps, File mainArtifact) throws MojoExecutionException, IOException {
        File obrDir = new File(this.getMavenContext().getProject().getBuild().getDirectory(), "obr");
        obrDir.mkdir();
        File depDir = new File(obrDir, "dependencies");
        depDir.mkdir();
        for (File dep : deps) {
            FileUtils.copyFileToDirectory((File)dep, (File)depDir, (boolean)true);
        }
        File obrXml = new File(obrDir, "obr.xml");
        for (File dep : depDir.listFiles()) {
            this.getMavenGoals().generateObrXml(dep, obrXml);
        }
        FileUtils.copyFileToDirectory((File)mainArtifact, (File)obrDir, (boolean)true);
        this.getMavenGoals().generateObrXml(mainArtifact, obrXml);
        return obrDir;
    }

    private List<File> resolvePluginDependencies() {
        ArrayList<File> deps = new ArrayList<File>();
        for (Artifact artifact : this.getMavenContext().getProject().getDependencyArtifacts()) {
            if (!this.pluginDependencies.contains(new PluginDependency(artifact.getGroupId(), artifact.getArtifactId()))) continue;
            deps.add(artifact.getFile());
        }
        return deps;
    }

    protected String getType() {
        return "obr";
    }
}

