/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.pdk;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;

public abstract class BasePdkMojo
extends AbstractMojo {
    protected ArtifactRepository localRepository;
    protected ArtifactFactory artifactFactory;

    protected void copyFiles(File source, File dest) {
        try {
            if (source.isDirectory()) {
                File[] files = source.listFiles();
                if (files.length != 0) {
                    this.getLog().info((CharSequence)("Copying " + files.length + " files to " + dest.getPath()));
                }
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].isDirectory()) {
                        BasePdkMojo.copy(files[i], new File(dest, files[i].getName()));
                        continue;
                    }
                    if (files[i].getName().equals("CVS") || files[i].getName().equals(".svn")) continue;
                    File sourceDir = new File(source + File.separator + files[i].getName());
                    File destDir = new File(dest + File.separator + files[i].getName());
                    destDir.mkdir();
                    this.copyFiles(sourceDir, destDir);
                }
            } else if (source.exists()) {
                BasePdkMojo.copy(source, dest);
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }

    protected static void copy(File source, File dest) throws IOException {
        if (source.isDirectory()) {
            FileChannel in = null;
            AbstractInterruptibleChannel out = null;
            try {
                in = new FileInputStream(source).getChannel();
                out = new FileOutputStream(dest).getChannel();
                long size = in.size();
                MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                ((FileChannel)out).write(buf);
            }
            catch (IOException t) {
                throw t;
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                dest.setLastModified(source.lastModified());
            }
        } else {
            int len;
            if (!dest.isDirectory()) {
                dest = new File(dest.getParent());
            }
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(new File(dest.getPath() + File.separator + source.getName()));
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    protected Artifact getArtifact(String groupId, String artifactId, String version, String type) {
        return this.artifactFactory.createArtifact(groupId, artifactId, version, "runtime", type);
    }

    protected String urlEncode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return text;
        }
    }
}

