/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.BannedArtifactsProvider;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.project.MavenProject;

class BannedArtifactsProviderImpl
implements BannedArtifactsProvider {
    private static final Set<String> DISALLOWED_PUBLIC_ARTIFACT_IDS = ImmutableSet.of((Object)"platform-public-api", (Object)"platform-deprecated-public-api");
    private static final Set<String> INTERNAL_ARTIFACT_IDS = ImmutableSet.of((Object)"platform-internal-api");
    @Component
    private MavenProject mavenProject;

    BannedArtifactsProviderImpl() {
    }

    @Override
    public Set<String> getBannedArtifacts(boolean forceInternal) {
        boolean internal;
        boolean bl = internal = forceInternal || this.isInternalPlugin();
        if (internal) {
            return BannedArtifactsProviderImpl.union(DISALLOWED_PUBLIC_ARTIFACT_IDS, INTERNAL_ARTIFACT_IDS);
        }
        return DISALLOWED_PUBLIC_ARTIFACT_IDS;
    }

    private boolean isInternalPlugin() {
        return ProjectUtils.hasAtlassianGroupId(this.mavenProject.getArtifact().getGroupId());
    }

    private static Set<String> union(Set<String> first, Set<String> second) {
        return Stream.concat(first.stream(), second.stream()).collect(Collectors.toSet());
    }
}

