/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.xml;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

final class SpringXmlServiceProperty {
    private final String key;
    private final String value;

    private SpringXmlServiceProperty(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @JacksonXmlProperty
    String key() {
        return this.key;
    }

    @JacksonXmlProperty
    String value() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SpringXmlServiceProperty serviceProperty = (SpringXmlServiceProperty)other;
        if (!Objects.equals(serviceProperty.key, this.key)) {
            return false;
        }
        return Objects.equals(serviceProperty.value, this.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private String key = "";
        private String value = "";

        private Builder() {
        }

        Builder key(String key) {
            if (key == null) {
                throw new IllegalArgumentException("'key' must not be null");
            }
            if (StringUtils.isWhitespace((CharSequence)key)) {
                throw new IllegalArgumentException("'key' must not be blank or whitespace");
            }
            this.key = key;
            return this;
        }

        Builder value(String value) {
            if (value == null) {
                throw new IllegalArgumentException("'value' must not be null");
            }
            this.value = value;
            return this;
        }

        SpringXmlServiceProperty build() {
            if (StringUtils.isBlank((CharSequence)this.key)) {
                throw new IllegalStateException("'key' property is mandatory");
            }
            return new SpringXmlServiceProperty(this.key, this.value);
        }
    }
}

