/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.atlassian.maven.plugins.amps.util.StreamUtils;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.stream.Stream;

public final class NetworkUtils {
    private NetworkUtils() {
    }

    public static String getLoopbackInterface() {
        return NetworkUtils.getNetworkInterfaces().filter(NetworkUtils::isLoopback).map(NetworkInterface::getName).findFirst().orElseThrow(IllegalStateException::new);
    }

    private static Stream<NetworkInterface> getNetworkInterfaces() {
        try {
            return StreamUtils.stream(NetworkInterface.getNetworkInterfaces());
        }
        catch (SocketException e) {
            return Stream.empty();
        }
    }

    private static boolean isLoopback(NetworkInterface networkInterface) {
        try {
            return networkInterface.isLoopback();
        }
        catch (SocketException e) {
            return false;
        }
    }
}

