/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.pdk;

import com.atlassian.maven.plugins.amps.AbstractProductAwareMojo;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.PdkParams;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.upm.signing.tools.SignatureBuilder;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractInstallPluginMojo
extends AbstractProductAwareMojo {
    @Parameter(property="atlassian.plugin.key")
    private String pluginKey;
    @Parameter(property="project.groupId")
    private String groupId;
    @Parameter(property="project.artifactId")
    private String artifactId;
    @Parameter(property="http.port")
    private int httpPort;
    @Parameter(property="context.path")
    private String contextPath;
    @Parameter(property="username", defaultValue="admin")
    private String username;
    @Parameter(property="password", defaultValue="admin")
    private String password;
    @Parameter(property="server", defaultValue="localhost")
    private String server;
    @Parameter(property="signature")
    private String signatureProperty;
    @Parameter(property="signatureFile")
    private String signatureFile;
    @Parameter(property="privateKey")
    private String privateKey;
    @Parameter(property="privateKeyFile")
    private String privateKeyFile;

    protected final void installPlugin(boolean isTestPlugin) throws MojoExecutionException {
        this.ensurePluginKeyExists();
        ProductHandler productHandler = this.getProductHandler(this.getProductId());
        String pluginFileName = this.getPluginFileName(isTestPlugin);
        String signature = this.getSignature();
        if (signature == null) {
            signature = this.forgeSignature(pluginFileName);
        }
        this.getLog().error((CharSequence)("getting signature for file " + pluginFileName + " : " + signature));
        this.getMavenGoals().installPlugin(new PdkParams.Builder().testPlugin(isTestPlugin).pluginFile(pluginFileName).pluginKey(this.pluginKey).server(this.server).port(this.getPort(this.server, productHandler)).contextPath(this.getContextPath(productHandler)).username(this.username).password(this.password).signature(signature).build());
    }

    private String getPluginFileName(boolean isTestPlugin) {
        MavenContext mavenContext = this.getMavenContext();
        StringBuilder sb = new StringBuilder(mavenContext.getBuildDirectory());
        sb.append("/").append(mavenContext.getProject().getBuild().getFinalName());
        if (isTestPlugin) {
            sb.append("-tests");
        }
        sb.append(".").append(mavenContext.getProject().getPackaging());
        return sb.toString();
    }

    private String getSignature() throws MojoExecutionException {
        return this.getPropertyValue(this.signatureProperty, "signature", this.signatureFile, "signatureFile").orElse(null);
    }

    private String forgeSignature(String file) throws MojoExecutionException {
        return this.getPropertyValue(this.privateKey, "privateKey", this.privateKeyFile, "privateKeyFile").map(SignatureBuilder::withPrivateKey).map(sb -> sb.forgeSignature(new File(file))).orElse(null);
    }

    private void ensurePluginKeyExists() {
        if (this.pluginKey == null) {
            this.pluginKey = this.groupId + "." + this.artifactId;
        }
    }

    private int getPort(String server, ProductHandler handler) {
        if (this.httpPort != 0) {
            return this.httpPort;
        }
        return server.startsWith("https://") ? handler.getDefaultHttpsPort() : handler.getDefaultHttpPort();
    }

    private String getContextPath(ProductHandler handler) {
        return this.contextPath == null ? "/" + handler.getId() : this.contextPath;
    }
}

